/*-----------------------------------------------------------------------------------
Copyright (c)2003 Borland Software Corporation. Patents pending. All rights reserved.
-----------------------------------------------------------------------------------*/

package class_diagram.package1.package2;

import java.util.ArrayList;
import java.util.Iterator;
/**
 * Knows its observers. Any number of Observer objects
 * may observe a subject. Provides an interface for attaching
 * and detaching Observer objects.
 * @role __Subject
 */
public class Subject {
	private ArrayList observers;

	public void attach(Observer observer) {
		observers.add(observer);
	}


	public void detach(Observer observer) {
		observers.remove(observer);
	}


	public void notifyObservers() {
		Iterator it = observers.iterator();
		while (it.hasNext()) {
			((Observer) it.next()).update(this);
		}
	}


}