/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.rf.repository.service/60NW_SP_COR/src/_serviceacl/java/api/com/sapportals/wcm/repository/service/serviceacl/IAclService.java#3 $
 */

package com.sapportals.wcm.repository.service.serviceacl;

import com.sapportals.portal.security.usermanagement.*;

import com.sapportals.wcm.repository.IResource;
import com.sapportals.wcm.repository.ResourceException;
import com.sapportals.wcm.repository.security.IResourceAclManager;
import com.sapportals.wcm.util.acl.IAclPermission;

/**
 * Handling of ACLs associated to other repository services. <br>
 *
 */
public interface IAclService {
  public boolean isAllowed(IResource resource, IUser user, IAclPermission permission)
    throws ResourceException;

  public IResourceAclManager getAclManager();
}
