package com.sap.caf.rt.security.acl.impl.permission;

import java.util.Collection;

import javax.ejb.EJBLocalObject;

import com.sap.caf.rt.exception.ServiceException;

public interface PermissionLocal extends EJBLocalObject {

	public void create(String businessRuleID, String principalID, String permissionName) throws ServiceException;
	public boolean isPermissionExist(String businessRuleID, String principalID, String permissionName) throws ServiceException;
	public void update(String businessRuleID, String permissionName, String nameBackUp, String principalID) throws ServiceException;
	public void delete (String businessRuleID, String principalID, String permissionName) throws ServiceException;

	public Collection checkPermission(String principalID,String objectID,String objectType) throws ServiceException;
	public Collection findByObjectType(String principalID, String objectType) throws ServiceException;
	public Collection findByPrincipalBusinessRules(String businessRuleID, String principalID, String objectType) throws ServiceException;
	public Collection findByObjectID(String objectID) throws ServiceException;
	public Collection findByBusinessRuleID(String currentUserID, String businessRuleID) throws ServiceException;
}

