package com.sap.caf.km.datasvc.ejb;

import java.rmi.RemoteException;

import javax.ejb.EJBObject;

import com.sap.caf.km.datasvc.data.BO;
import com.sap.caf.km.datasvc.data.BODescription;
import com.sap.caf.km.datasvc.data.BOInstance;
import com.sap.caf.km.datasvc.data.Relation;
import com.sap.caf.km.datasvc.exceptions.AccessDeniedException;
import com.sap.caf.km.datasvc.exceptions.DataServiceWSException;

public interface CAFDataService extends EJBObject {
	
	/**
	 * @see com.sap.caf.km.datasvc.ICAFDataService#getAllBOs()
	 */	
	public BODescription[] getAllBOs() throws RemoteException, DataServiceWSException;

	/**
	 * @see com.sap.caf.km.datasvc.ICAFDataService#getAssociatedBOs(String)
	 */
	public Relation[] getAssociatedBOs(String guidBO) throws RemoteException, DataServiceWSException;

	/**
	 * @see com.sap.caf.km.datasvc.ICAFDataService#getAggregatedBOs(String)
	 */	
	public Relation[] getAggregatedBOs(String guidBO) throws RemoteException, DataServiceWSException;

	/**
	 * @see com.sap.caf.km.datasvc.ICAFDataService#getBO(String, String, String)
	 */		
	public BO getBO(String provider, String application, String bo) throws RemoteException, DataServiceWSException;

	/**
	 * @see com.sap.caf.km.datasvc.ICAFDataService#getBOInstance(String, String)
	 */		
	public BOInstance getBOInstance(String guidBO, String guidInstance) throws RemoteException, DataServiceWSException, AccessDeniedException;	

	/**
	 * @see com.sap.caf.km.datasvc.ICAFDataService#getInstancesByGUIDPart(String, String)
	 */	
	public String[] getInstancesByGUIDPart(String guidBO, String guidPart)
				throws RemoteException, DataServiceWSException;

	/**
	 * @see com.sap.caf.km.datasvc.ICAFDataService#getRelatedInstancesByGUIDPart(String, String, String, String)
	 */					
	public String[] getRelatedInstancesByGUIDPart(String guidBO, String guidRelation, String guidInstance, String guidPart)
				throws RemoteException, DataServiceWSException, AccessDeniedException;

	/**
	 * @see com.sap.caf.km.datasvc.ICAFDataService#getBOByGUID(String)
	 */					
	public BO getBOByGUID(String guid)
				throws RemoteException, DataServiceWSException;

	/**
	 * @see com.sap.caf.km.datasvc.ICAFDataService#getRelatedBOByRelationGUID(String)
	 */	
	public BO getRelatedBOByRelationGUID(String relationGuid)
				throws RemoteException, DataServiceWSException;
								
	/**
	 * @see com.sap.caf.km.datasvc.ICAFDataService#getPopulatedFolders(String, int, String)
	 */	
	public String[] getPopulatedFolders(String guid, int noDigits, String startGuid)
				throws RemoteException, DataServiceWSException;	

	/**
	 * @see com.sap.caf.km.datasvc.ICAFDataService#getRelatedPopulatedFolders(String, String, String, int, String)
	 */	
	public String[] getRelatedPopulatedFolders(String guidBO, String guidRelation, String guidInstance, int digits, String guidPart)
				throws RemoteException, DataServiceWSException;

	/**
	 * @see com.sap.caf.km.datasvc.ICAFDataService#getDOs(String, String[])
	 */	
	public Relation[] getComplexAttributes(String guidBO, String[] guidRelation)
				throws RemoteException, DataServiceWSException;

	/**
	* @see com.sap.caf.km.datasvc.ICAFDataService#getDOInstances(String, String, String[], String[])
	*/
	public String[] getComplexAttributeInstances(String guidBO, String guidInstance, String[] guidRelation, String[] guidDOInstance)
				throws RemoteException, DataServiceWSException;

	/**
	 * @see com.sap.caf.km.datasvc.ICAFDataService#getDOByRelationGUID(String)
	 */	
	public BO getComplexAttribute(String guidDO)
				throws RemoteException, DataServiceWSException;
				
	/**
	 * @see com.sap.caf.km.datasvc.ICAFDataService#getDOInstance(String, String, String[], String[])
	 */	
	public BOInstance getComplexAttributeInstance(String guidBO, String guidBOInstance, String[] guidDO, String[] guidDOInstance)
				throws RemoteException, DataServiceWSException, AccessDeniedException;
				
	public String[] getRelatedKMObjects(String fullBONames) 
				throws RemoteException, DataServiceWSException;
				
	public boolean[] checkRights(String guidBO, String guidInstance, String[] rightsToCheck) throws RemoteException, DataServiceWSException, AccessDeniedException;				

	public boolean isConnectionLoopbackAlive() throws RemoteException, DataServiceWSException;
}
