#!/usr/lib/perl
# installs SAP DBTech perl modules
#
#    ========== licence begin LGPL
#    Copyright (C) 2000 SAP AG
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#    ========== licence end
#


use File::Path;
use File::Copy;
use File::Basename;
fileparse_set_fstype ($^O);
$installLocation = dirname ($0);
$quiet = 0;

sub CheckDir {
    my($dir) = @_;
    if(! -d $dir) {
        if (!$quiet) {
            print "Creating directory $dir...\n";
        }
        if ($doCopy) {
            mkpath ($dir) or die "ERROR: ($!)\n";
        }
    }
}

if ($^O eq 'MSWin32') {
    $copyCommand = 'cmd /c copy';
    $dllExtension = '.dll';
}
else {
    $copyCommand = 'cp';
    $dllExtension = '.so';
}

sub CopyFile {
    my ($source, $target) = @_;

    if (!$quiet) {
        print "Copying $source to $target\n";
    }
    if ($doCopy) {
        if (-d $target) {
            $target .= "/$source";
        }
        $source = $installLocation . "/$source";
        copy ($source, $target) || die "copying $source: $!";
    }
}

sub InstModule {
    use Config;

    my ($modname, $package, $perlkind) = @_;
    $PERLLIB     = $Config{'privlib'};
    $SITELIB     = $Config{'sitelib'};
    $SITEARCHLIB = $Config{'sitearch'};

    $DLL         = $modname . $perlkind;
    $PM          = 'SAP/DBTech/' . $modname . '.pm';

    $pmDir = "$SITELIB$package";
    CheckDir($pmDir);
    CopyFile ($PM, $pmDir);

    $dllDir = $SITEARCHLIB."/auto$package/$DLL";
    CheckDir($dllDir);
    CopyFile ($DLL . $dllExtension, $dllDir);

    if ($doCopy) {
        open( DOC_INSTALL, ">> $PERLLIB/perllocal.pod");

        print DOC_INSTALL "=head2 ", scalar(localtime), ": C<Module> L<$modname>\n\n".
                          "=over 4\n\n".
                          "=item *\n\n".
                          "C<installed into: $pmDir>\n\n".
                          "=item *\n\n".
                          "C<LINKTYPE: dynamic>\n\n".
                          "=item *\n\n".
                          "C<VERSION: $VERSION>\n\n".
                          "=item *\n\n".
                          "C<EXE_FILES: >\n\n".
                          "=back\n\n";

        close(DOC_INSTALL);
    }

}

sub instDBD {
    use Config;
    $SITELIB     = $Config{'sitelib'};

    $PM          = 'DBD/SAP_DB.pm';
    $pmDir       = $SITELIB . '/DBD';

    if (-d $pmDir) {
        CopyFile ($PM, $pmDir);
    }
}
# main program

use Getopt::Std;

$doCopy = 1;
$VERSION = "7.4";
@Modules = ('dbm', 'loader');
$package = '/SAP/DBTech';

getopts('nhq');

if ( defined($opt_h)) {
	print "Usage: instperl [-n] [-q] modules\n";
    print "    installs the specified modules into the current perl installation\n";
    print "    -n       no operation (show where the modules would be copied to)\n";
    print "    -q       quiet, no output\n";
	exit 11;
}

if (defined ($opt_n)) { # -n: no action
    $doCopy = 0;
}

if (defined ($opt_q)) { # -q: quiet
    $quiet = 1;
}

if (@ARGV > 0) {
    @Modules = @ARGV;
}

if(defined(&Win32::BuildNumber)) {
    # ActiveWare
    $perlkind = 'aperl'
} else {
    # core
    $perlkind = 'cperl'
}

foreach $module (@Modules) {
    eval {InstModule ($module, $package, $perlkind);};
    if ($@) {
        print "Installation of $module failed: $@\n";
    }
}

# &instDBD ();

if ($doCopy) {
    if (!$quiet) {
        print "Installation complete.\n";
    }
}
else {
    print "Nothing copied because of -n option\n";
}

1;
