#
#    ========== licence begin LGPL
#    Copyright (C) 2002 SAP AG
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#    ========== licence end
#

import sys

_pythonVersion = sys.version [:3]

del sys

try:
    from pythondef.loader import *
    from pythondef.loader import _buildInfo
except ImportError:
    if _pythonVersion == "2.3":
        from python23.loader import *
        from python23.loader import _buildInfo
    elif _pythonVersion == "2.2":
        from python22.loader import *
        from python22.loader import _buildInfo
    elif _pythonVersion == "2.1":
        from python21.loader import *
        from python21.loader import _buildInfo
    elif _pythonVersion == "2.0":
        from python20.loader import *
        from python20.loader import _buildInfo
    elif _pythonVersion == "1.5":
        from python15.loader import *
        from python15.loader import _buildInfo
    else:
        raise "Python version not supported", _pythonVersion

del _pythonVersion

