/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.crt/60NW_SP_COR/src/_framework/java/api/com/sapportals/wcm/crt/configuration/IConfigurationProvider.java#2 $
 */

package com.sapportals.wcm.crt.configuration;

/**
 * A configuration provider is resposible for translating the configuration data
 * into {@link IConfiguration} objects needed by the CRT. Implementations should
 * use the {@link DefaultConfiguration} object. <p>
 *
 * <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author Markus Breitenfelder
 * @version $Id: //kmgmt/bc.crt/dev/src/_framework/java/api/com/sapportals/wcm/crt/configuration/IConfigurationProvider.java#3
 *      $
 */
public interface IConfigurationProvider {
  /**
   * Returns the top-level configuration element that contains the complete
   * configuration data for a single CRT client.
   *
   * @param classLoader Class loader to use.
   * @return the configuration data.
   * @exception ConfigurationException If an error was detected in the
   *      configuration.
   */
  IConfiguration readConfiguration(ClassLoader classLoader)
    throws ConfigurationException;

  /**
   * This method is called by the CRT to attach a listener for configuration
   * events. This method will be called only once.
   *
   * @param listener The listener instance.
   */
  void attachEventListener(IConfigurationEventListener listener);
}
