/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.crt/60NW_SP_COR/src/_framework/java/api/com/sapportals/wcm/crt/component/IStartable.java#2 $
 */

package com.sapportals.wcm.crt.component;

/**
 * A component must implement this interface if it has to acquire/release
 * resources in order to execute its service methods. The stop() method will be
 * called only once during the life-time of a component. The start() method will
 * be called once - or multible times if the components implements {@link
 * IAutoStartable}. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author Jens Kaiser
 * @version $Id: //kmgmt/bc.crt/dev/src/_framework/java/api/com/sapportals/wcm/crt/component/IStartable.java#3
 *      $
 */
public interface IStartable {
  /**
   * A component must implement this method if it has initial startup handling
   * to do before being accessible (acquire resources, open connections to
   * remote systems, etc). This method is only called once during the life-time
   * of a component except an {@link AutoRestartException} was thrown.
   *
   * @exception StartupException If the initialization failed because neccessary
   *      resources could not be allocated.
   */
  void start()
    throws StartupException;

  /**
   * This method is only called once during the life-time of a component. It is
   * called by the CRT when the component was removed from the configuration or
   * the system shuts down. A stopped component can not be (re)started. After a
   * shutdown the component instance will be finalized by the Java VM as soon as
   * no other components in the system holds a reference to it.
   */
  void stop();
}
