/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.crt/60NW_SP_COR/src/_framework/java/api/com/sapportals/wcm/crt/component/IProxy.java#2 $
 */

package com.sapportals.wcm.crt.component;

import java.lang.reflect.InvocationHandler;

/**
 * An interface to mark a component as a proxy. <p>
 *
 * A proxy component processes a component's method invocations. {@link
 * InvocationHandler#invoke(Object,java.lang.reflect.Method,Object[]) invoke} will be invoked on a
 * proxy when a method is invoked on a component instance that it is associated
 * with.<p>
 *
 * Proxies could implement {@link InvocationHandler#invoke(Object,java.lang.reflect.Method,Object[])
 * invoke} like in the following example: <pre>
 * public Object invoke( Object proxy, Method m, Object[] args ) throws Throwable {
 *   Object result = null;
 *
 *   try {
 *     ....preInvoke
 *     // call the method
 *     result = m.invoke( component, args );
 *
 *   } catch( InvocationTargetException e ) {
 *     throw e.getTargetException();
 *   } catch( Exception e ) {
 *     getCategory().error( e.getMessage(), e );
 *     throw new RuntimeException( "unexpected invocation exception: " + e.getMessage() );
 *   } finally {
 *     ....postInvoke
 *   }
 *   return result;
 * }
 * </pre> <p>
 *
 * A proxy-armed component could be added during configuration time like in the
 * following code example: <pre>
 * DefaultConfiguration component = new DefaultConfiguration( IConfigConst.ELEMENTS.COMPONENT );
 * component.setAttribute( IConfigConst.ATTRIBUTES.COMPONENT_CLASS, SomeComponent.class.getName() );
 * component.setAttribute( IConfigConst.ATTRIBUTES.COMPONENT_KEY, "someKey" );
 * component.setAttribute( IConfigConst.ATTRIBUTES.COMPONENT_PROXY, ProxyComponent.class.getName() );
 * </pre> Or during runtime like in the following example: <pre>
 * getContainerManager().addChild( key, className, proxyName, config, params );
 * </pre> <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author Jens Kaiser
 * @version $Id: //kmgmt/bc.crt/dev/src/_framework/java/api/com/sapportals/wcm/crt/component/IProxy.java#3
 *      $
 */
public interface IProxy extends IContextualizable, InvocationHandler {

  /**
   * Returns the interface closure the proxy implements
   *
   * @return interfaces
   */
  Class[] getInterfaces();
}
