/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.crt/60NW_SP_COR/src/_framework/java/api/com/sapportals/wcm/crt/component/IPoolable.java#2 $
 */

package com.sapportals.wcm.crt.component;

/**
 * An interface to mark a component as poolable. (Poolable components MUST NOT
 * implement IThreadSafe). This means, that component instances will be managed
 * in a pool by the CRT. If lookup() is called the CRT will try to return an
 * existing instance from the pool. A poolable component can also be {@link IReusable}. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author Jens Kaiser
 * @version $Id: //kmgmt/bc.crt/dev/src/_framework/java/api/com/sapportals/wcm/crt/component/IPoolable.java#3
 *      $
 */
public interface IPoolable {
}
