/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.crt/60NW_SP_COR/src/_framework/java/api/com/sapportals/wcm/crt/component/ILifecycleInfo.java#2 $
 */

package com.sapportals.wcm.crt.component;

import com.sapportals.wcm.crt.configuration.IConfiguration;
import com.sapportals.wcm.crt.configuration.ConfigurationException;

import java.util.Date;

/**
 * This interface can be impemented by components that want to provide
 * information about their life-cycle. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author Markus Breitenfelder
 */
public interface ILifecycleInfo {
  /**
   * Returns the current life-cycle state of the component. Can be <code>null
   * </null>.
   *
   * @return the current life-cycle state of the component. Can be <code>null
   *      </null>.
   */
  ComponentState getState();

  /**
   * Returns the exception thrown in the last call to {@link IConfigurable#configure(IConfiguration)}, 
   * or {@link IReconfigurable#reconfigure(IConfiguration)}. Can be
   * <code>null</code> .
   *
   * @return lastConfigurationException
   * @returns the last configuration exception. Can be <code>null</null> .
   */
  ConfigurationException getLastConfigurationException();

  /**
   * Returns the exception thrown in the last call to {@link IStartable#start()},
   * Can be <code>null</code> .
   *
   * @return startupException
   * @returns the startup exception. Can be <code>null</null> .
   */
  StartupException getStartupException();

  /**
   * Returns the date and time of the creation of the component instance. Can be
   * <code>null</null> . This property usually makes sense only for components
   * that implement the IThreadSafe interface.
   *
   * @return the date and time of the creation of the component instance. Can be
   *      <code>null</null> .
   */
  Date getCreationDate();

  /**
   * Returns the date and time of the last reconfiguration of this component.
   * Can be <code>null</null> .
   *
   * @return the date and time of the last reconfiguration of this component.
   *      Can be <code>null</null> .
   */
  Date getLastReconfigurationDate();

  /**
   * Returns the date and time of the next automatic restart of the component.
   * Can be <code>null</null> .
   *
   * @return the date and time of the next automatic restart of the component.
   *      Can be <code>null</null> .
   * @see AutoRestartException
   */
  Date getNextAutoRestartDate();
}
