/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.crt/60NW_SP_COR/src/_framework/java/api/com/sapportals/wcm/crt/component/IContextualizable.java#2 $
 */

package com.sapportals.wcm.crt.component;

/**
 * This inteface can be implemented by components that need a context. A context
 * contains runtime information and servicesa provided by the CRT or a container
 * component. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author Jens Kaiser
 * @version $Id: //kmgmt/bc.crt/dev/src/_framework/java/api/com/sapportals/wcm/crt/component/IContextualizable.java#3
 *      $
 */
public interface IContextualizable {
  /**
   * Pass the context to the component.
   *
   * @param context The context objects
   * @exception ContextException if the context is invalid
   */
  void contextualize(IContext context)
    throws ContextException;
}
