/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.crt/60NW_SP_COR/src/_framework/java/api/com/sapportals/wcm/crt/component/IContext.java#2 $
 */

package com.sapportals.wcm.crt.component;

import com.sap.tc.logging.Category;

/**
 * The context contains services, settings and information that is supplied by
 * the CRT and/or a container to the component. A context implementation should
 * be read-only. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author Jens Kaiser
 * @version $Id: //kmgmt/bc.crt/dev/src/_framework/java/api/com/sapportals/wcm/crt/component/IContext.java#3
 *      $
 */
public interface IContext {
  /**
   * Returns the component's key as specified in the configuration.
   *
   * @return The key value
   */
  String getKey();


  /**
   * Returns a reference to the component's container manager. Will always
   * return <code>null</code> if the component does not implement {@link
   * IContainer},
   *
   * @return The containerManager value
   */
  IContainerManager getContainerManager();

  /**
   * Returns the class of the component that this context belongs to
   *
   * @return componentClass
   */
  Class getComponentClass();

  /**
   * Returns the class of the proxy
   *
   * @return proxyClass
   */
  Class getProxyClass();

  /**
   * Returns a category for logging
   *
   * @return category
   */
  Category getCategory();

  /**
   * Returns a default size for a component pool.
   *
   * @return defaultPoolSize
   * @see IPoolable
   */
  int getDefaultPoolSize();

  /**
   * Returns the maximum size for a component pool.
   *
   * @return maximumPoolSize
   * @see IPoolable
   */
  int getMaximumPoolSize();

  /**
   * Returns a parameters object.
   *
   * @return The parameters value
   */
  Object getParameters();
}
