/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.crt/60NW_SP_COR/src/_framework/java/api/com/sapportals/wcm/crt/component/IContainerManager.java#2 $
 */

package com.sapportals.wcm.crt.component;

import com.sapportals.wcm.crt.configuration.ConfigurationException;
import com.sapportals.wcm.crt.configuration.IConfiguration;

/**
 * A container manager is used by container components for managing their
 * children. This interface inherits from {@link IComponentManager}. The
 * additional methods defined in this interface are used by the container to
 * create and remove its children. <p>
 *
 *      Copyright (c) SAP AG 2001-2002
 * @author Markus Breitenfelder
 * @see IContainer
 * @version $Id: //kmgmt/bc.crt/dev/src/_framework/java/api/com/sapportals/wcm/crt/component/IContainerManager.java#3
 *      $
 */
public interface IContainerManager extends IComponentManager {

  /**
   * Adds a child component with the specified key, java class name and
   * configuration data.
   *
   * @param key The new component's key.
   * @param className The name of the new component's java class.
   * @param proxyName The name of a component's proxy class.
   * @param config Configuration data.
   * @param parameters Some arbitrary parameters that will be put into the
   *      component context. The parameters should be read-only.
   * @exception ConfigurationException Exception raised in failure situation
   * @exception ComponentException Exception raised in failure situation
   */
  void addChild(String key, String className, String proxyName, IConfiguration config, Object parameters)
    throws ConfigurationException, ComponentException;


  /**
   * Adds a pooled child component with the specified key, java class name and
   * configuration data.
   *
   * @param key The new component's key.
   * @param className The name of the new component's java class.
   * @param proxyName The name of a component's proxy class.
   * @param config Configuration data.
   * @param parameters Some arbitrary parameters that will pe put into the
   *      component context. The parameters should be read-only.
   * @param defaultPoolSize
   * @param maximumPoolSize
   * @exception ConfigurationException Exception raised in failure situation
   * @exception ComponentException Exception raised in failure situation
   */
  void addChild(String key, String className, String proxyName, IConfiguration config, Object parameters,
    int defaultPoolSize, int maximumPoolSize)
    throws ConfigurationException, ComponentException;

  /**
   * Removes a child component with the specified key. If a component with the
   * specified key does not exist nothing happens.
   *
   * @param key The key of the component to remove.
   */
  void removeChild(String key);
}
