/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.crt/60NW_SP_COR/src/_framework/java/api/com/sapportals/wcm/crt/component/IContainer.java#2 $
 */

package com.sapportals.wcm.crt.component;

/**
 * A component can choose to implement this interface to become the container
 * for child components. The child components can be defined in the
 * configuration data or can be added by the container during runtime. <p>
 *
 *      Copyright (c) SAP AG 2001-2002
 *
 * @author Markus Breitenfelder
 * @see IContainerManager
 * @version $Id: //kmgmt/bc.crt/dev/src/_framework/java/api/com/sapportals/wcm/crt/component/IContainer.java#3
 *      $
 */
public interface IContainer extends IComponent, IContextualizable {
  /**
   * Returns the component manager for accessing this container's child
   * components.
   *
   * @return the component manager for accessing this container's child
   *      components.
   */
  public IComponentManager getComponentManager();
}
