/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.crt/60NW_SP_COR/src/_framework/java/api/com/sapportals/wcm/crt/component/IConfigurable.java#2 $
 */

package com.sapportals.wcm.crt.component;
import com.sapportals.wcm.crt.configuration.ConfigurationException;
import com.sapportals.wcm.crt.configuration.IConfiguration;

/**
 * This interface must be implemented by components that need to be configured
 * with parameters from the configuration data delivered by the configuration
 * provider. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author Markus Breitenfelder
 * @version $Id: //kmgmt/bc.crt/dev/src/_framework/java/api/com/sapportals/wcm/crt/component/IConfigurable.java#3
 *      $
 */
public interface IConfigurable {
  /**
   * Passes the configuration data to the configurable. This method will by
   * called by the CRT only once. It is called after construction and
   * contextualization and before startup (if implemented).
   *
   * @param configuration the component's configuration data.
   * @exception ConfigurationException Exception raised in failure situation
   */
  void configure(IConfiguration configuration)
    throws ConfigurationException;
}
