/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.crt/60NW_SP_COR/src/_framework/java/api/com/sapportals/wcm/crt/component/IComponentManager.java#2 $
 */

package com.sapportals.wcm.crt.component;

/**
 * A component manager manages all root components of a CRT client or all
 * components within a container component. Components are identified by a key.
 * <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author Markus Breitenfelder
 * @version $Id: //kmgmt/bc.crt/dev/src/_framework/java/api/com/sapportals/wcm/crt/component/IComponentManager.java#3
 *      $
 */
public interface IComponentManager {
  /**
   * Returns the component instance for the specified key or <code>null</code>
   * if the component was not found.
   *
   * @param key The component key to look for. Keys are case-sensitive. <p>
   *
   *      The caller must subseqently call <code>releaseComponent()</code> when
   *      it is finished using the component. This is optional for thread-safe
   *      components.
   * @return the component instance.
   * @exception ComponentException If the component could not be instanciated.
   */
  IComponent lookupComponent(String key)
    throws ComponentException;

  /**
   * Returns true if the component with the specified key exists.
   *
   * @param key The component key to look for. Keys are case-sensitive.
   * @return True if the component exists.
   */
  boolean hasComponent(String key);

  /**
   * Releases the component. This method should be called when the caller is
   * finished using the component. It must be called for all components that do
   * not implement the {@link IThreadSafe} interface - it is optional for
   * thread-safe components.
   *
   * @param component A reference to the component to release.
   */
  void releaseComponent(IComponent component);

  /**
   * Returns an array of the keys of all components contained in this manager.
   *
   * @return An array of the keys of all components contained in this manager.
   */
  String[] listComponentKeys();
}
