/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.crt/60NW_SP_COR/src/_framework/java/api/com/sapportals/wcm/crt/component/IComponentInfo.java#2 $
 */

package com.sapportals.wcm.crt.component;
import java.util.Locale;

import java.util.Properties;

/**
 * Information about the component such as name, description, etc. <p>
 *
 * Copyright (c) SAP AG 2001-2003
 *
 * @author jens.kaiser@sap.com
 * @author m.breitenfelder@sap.com
 * @version $Id: //kmgmt/bc.crt/dev/src/_framework/java/api/com/sapportals/wcm/crt/component/IComponentInfo.java#3
 *      $
 */
public interface IComponentInfo {

  /**
   * Returns the component's human-readable name or <code>null</code> .
   *
   * @return the component's human-readable name or <code>null</code> .
   */
  public String getName();

  /**
   * Returns a description of the components purpose or <code>null</code> .
   *
   * @param locale Selects the language of the description text - can be <code>
   *      null</code> .
   * @return a description of the components purpose or <code>null</code> .
   */
  public String getDescription(Locale locale);

  /**
   * Returns some arbitrary properties with information about the component or
   * <code>null</code> .
   *
   * @return some arbitrary properties with information about the component or
   *      <code>null</code> .
   */
  public Properties getProperties();
}
