/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.crt/60NW_SP_COR/src/_framework/java/api/com/sapportals/wcm/crt/component/ContextException.java#2 $
 */

package com.sapportals.wcm.crt.component;

import com.sapportals.wcm.crt.CascadingException;

/**
 * The {@link IContext} is invalid. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author Jens Kaiser
 * @author Markus Breitenfelder
 * @version $Id: //kmgmt/bc.crt/dev/src/_framework/java/api/com/sapportals/wcm/crt/component/ContextException.java#3
 *      $
 */
public class ContextException extends CascadingException {
  /**
   * Construct a new <code>ContextException</code> instance.
   *
   * @param message The detail message for this exception.
   */
  public ContextException(final String message) {
    this(message, null);
  }

  /**
   * Construct a new <code>ContextException</code> instance.
   *
   * @param message The detail message for this exception.
   * @param throwable the root cause of the exception
   */
  public ContextException(final String message, final Throwable throwable) {
    super(message, throwable);
  }
}
