/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.crt/60NW_SP_COR/src/_framework/java/api/com/sapportals/wcm/crt/component/ComponentState.java#2 $
 */

package com.sapportals.wcm.crt.component;

/**
 * An enumeration of a component's possible states during runtime. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author Jens Kaiser
 * @author Markus Breitenfelder
 * @see ILifecycleInfo
 * @version $Id: //kmgmt/bc.crt/dev/src/_framework/java/api/com/sapportals/wcm/crt/component/ComponentState.java#3
 *      $
 */
public class ComponentState {

  /**
   * Before {@link IStartable#start()} was called
   */
  public final static ComponentState NOT_INIT = new ComponentState("not started");

  /**
   * If {@link IStartable#start()} failed
   */
  public final static ComponentState INIT_ERROR = new ComponentState("startup failed");

  /**
   * The component is accessible, that means it was successfully started.
   */
  public final static ComponentState RUNNING = new ComponentState("running");

  /**
   * The component is not accessible, that means it is suspended or shut down.
   */
  public final static ComponentState STOPPED = new ComponentState("stopped");

  private String name;

  
  
  private ComponentState(String code) {
    this.name = code;
  }

  public String getName() {
    return this.name;
  }
  
	public boolean equals(Object obj) {
    if( obj instanceof ComponentState ) {
    	return this.name.equals(((ComponentState)obj).name);
    }
		return false;
	}
	
	public int hashCode() {
		return this.name.hashCode();
	}
	
  public String toString() {
    return this.getClass().getName() + "[" + this.name + "]";
  }

}
