/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.crt/60NW_SP_COR/src/_framework/java/api/com/sapportals/wcm/crt/component/ComponentException.java#2 $
 */

package com.sapportals.wcm.crt.component;

import com.sapportals.wcm.crt.CascadingException;

/**
 * The exception thrown to indicate a problem with Components. It is usually
 * thrown by ComponentManager or ComponentSelector. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author Jens Kaiser
 * @author Markus Breitenfelder
 * @version $Id: //kmgmt/bc.crt/dev/src/_framework/java/api/com/sapportals/wcm/crt/component/ComponentException.java#3
 *      $
 */
public class ComponentException extends CascadingException {
  /**
   * Construct a new <code>ComponentException</code> instance.
   *
   * @param message the exception message
   * @param throwable the throwable
   */
  public ComponentException(final String message, final Throwable throwable) {
    super(message, throwable);
  }

  /**
   * Construct a new <code>ComponentException</code> instance.
   *
   * @param message the exception message
   */
  public ComponentException(final String message) {
    super(message, null);
  }
}
