/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.crt/60NW_SP_COR/src/_framework/java/api/com/sapportals/wcm/crt/component/ComponentEvent.java#2 $
 */

package com.sapportals.wcm.crt.component;

import com.sapportals.wcm.crt.ComponentUri;

/**
 * The event contains the component's URI and java class object. The class
 * object can be used in event handler code to check for the type of a
 * component. For example the components interfaces can be queried (instead of
 * looking up the component first and using <code>instanceof</code> ): <p>
 *
 * <pre>
 * if (ISomeInterface.class.isAssignableFrom(event.getComponentClass())) {
 *   ISomeInterface c = (ISomeInterface)CrtSystem.getInstance().lookupComponentByUri(event.getComponentUri());
 * }
 * </pre> <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author Jens Kaiser
 * @author Markus Breitenfelder
 * @version $Id: //kmgmt/bc.crt/dev/src/_framework/java/api/com/sapportals/wcm/crt/component/ComponentEvent.java#3
 *      $
 */
public class ComponentEvent {

  public static class Type {
    public final static Type COMPONENT_ADDED = new Type("added");
    public final static Type COMPONENT_WILL_BE_REMOVED = new Type("will_be_removed");
    public final static Type COMPONENT_RECONFIGURED = new Type("reconfigured");
    String type;

    Type(String name) {
      type = name;
    }

    public String toString() {
      return type;
    }
  }


  private final ComponentUri uri;
  private final Class componentClass;
  private final Type type;

  public ComponentEvent(ComponentUri uri, Class componentClass, Type type) {
    this.uri = uri;
    this.componentClass = componentClass;
    this.type = type;
  }

  public ComponentUri getComponentUri() {
    return this.uri;
  }

  public Class getComponentClass() {
    return this.componentClass;
  }

  public Type getType() {
    return this.type;
  }
}
