/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.crt/60NW_SP_COR/src/_framework/java/api/com/sapportals/wcm/crt/component/AutoRestartException.java#2 $
 */

package com.sapportals.wcm.crt.component;

/**
 * This is a specialized startup exception that instructs the CRT to
 * automatically retry the startup. The CRT will restart the component in the
 * specified time interval. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author Jens Kaiser
 * @author Markus Breitenfelder
 * @version $Id: //kmgmt/bc.crt/dev/src/_framework/java/api/com/sapportals/wcm/crt/component/AutoRestartException.java#3
 *      $
 */
public final class AutoRestartException extends StartupException {

  private long delay;

  /**
   * Construct a new exception.
   *
   * @param message The message for this exception.
   * @param delay TBD: Description of the incoming method parameter
   */
  public AutoRestartException(final String message, long delay) {
    super(message);
    this.delay = delay;
  }

  /**
   * Construct a new exception.
   *
   * @param throwable the root cause of the exception.
   * @param delay TBD: Description of the incoming method parameter
   */
  public AutoRestartException(final Throwable throwable, long delay) {
    super(throwable);
    this.delay = delay;
  }


  /**
   * Construct a new exception.
   *
   * @param message The message for this exception.
   * @param throwable the root cause of the exception.
   * @param delay TBD: Description of the incoming method parameter
   */
  public AutoRestartException(final String message, final Throwable throwable, long delay) {
    super(message, throwable);
    this.delay = delay;
  }

  /**
   * Returns the retry interval in milliseconds.
   *
   * @return delay
   */
  public long getDelay() {
    return this.delay;
  }
}
