/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.crt/60NW_SP_COR/src/_framework/java/api/com/sapportals/wcm/crt/CascadingException.java#2 $
 */

package com.sapportals.wcm.crt;
import java.io.PrintStream;
import java.io.PrintWriter;

/**
 * Exception class which allows recording of nested exceptions. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author Markus Breitenfelder
 * @version $Id: //kmgmt/bc.crt/dev/src/_framework/java/api/com/sapportals/wcm/crt/CascadingException.java#3
 *      $
 */
public class CascadingException extends Exception {
  protected Throwable ex;

  public CascadingException() {
    super();
  }

  public CascadingException(String msg) {
    super(msg);
  }

  public CascadingException(String msg, Throwable ex) {
    super(msg);
    this.ex = ex;
  }

  public CascadingException(Throwable ex) {
    super(ex.getClass().getName() + ": " + ex.getMessage());
    this.ex = ex;
  }

  public Throwable getContainedException() {
    return this.ex;
  }

  public void printStackTrace() {
    super.printStackTrace();
    if (this.ex != null) {
      this.ex.printStackTrace();
    }
  }

  public void printStackTrace(PrintWriter pw) {
    super.printStackTrace(pw);
    if (this.ex != null) {
      this.ex.printStackTrace(pw);
    }
  }

  public void printStackTrace(PrintStream ps) {
    super.printStackTrace(ps);
    if (this.ex != null) {
      this.ex.printStackTrace(ps);
    }
  }
}
