package mdkInventory1.bean;

import java.util.Vector;

import mdkInventory1.Constants;
import mdkInventory1.dataAccess.SmartSyncDBAccess;

import com.sap.ip.me.api.services.MeIterator;

/**
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class BasicDataHandler implements Constants {
	private static int columns;
	private static Vector tableHeaderNamesToDisplay;
	private static MeIterator syncBos;
	private Vector retSubVec;
	private static BasicDataHandler bdh = null;
	private static SmartSyncDBAccess dbAccess = null;
	private static int start_index;
	private static int recCount;
	private int tablecolumns;
	private static String miHomeFolder;

	public static int rows_in_dataset;
	public static int tablerows;
	public static int current_index;

	/**
	 * String obj: item filter. Only items starting with a certain letter are displayed
	 * int sort_type: ascending/decending sorting
	 * int sortIndex: column index which whould be sorted
	 * int index: column (=index) for which filter is applied
	 */
	public static BasicDataHandler instance(int index, int sortIndex, boolean sort_type, String filter_string) {
		if (bdh == null)
			bdh = new BasicDataHandler();
		if (dbAccess == null)
			dbAccess = new SmartSyncDBAccess();

		syncBos = dbAccess.readEntitiesFromDB(index, sortIndex, sort_type, filter_string);
		setColumns(dbAccess.getColumns());
		// We need the amount of synbos for the navigation. So we get the counter once and 
		// update our the counter in the programm. Iterating over the syncbos should be done
		// too often.
		rows_in_dataset = 0;
		while (syncBos.hasNext()) {
			syncBos.next();
			rows_in_dataset++;
		}
		return bdh;
	}

	private String stringLoad(String var) {
		// This method checks if a String is null - if so, it uses a standard text
		String vartmp = var;
		if (vartmp == null)
			vartmp = "Not available";
		return vartmp;
	}

	//	creates  a subarray of the full dataset defined by a start index and the number of rows
	//  The result is returned and also kept locally as retSubVec to be retrieved by the bean

	public void getDataArray(int fromIndex, int count) {
		retSubVec = dbAccess.getEntities(syncBos, fromIndex, count);
		return;
	}

	//	returns a specific entry of the current subarray
	public String getCurrentSubTableContent(int row, int column) {
		//Check for end of Vector
		if (row >= retSubVec.size()) {
			// If there is no more data, return a blank
			return "&nbsp;";
		}
		Vector data = (Vector) retSubVec.get(row);
		return data.get(column).toString();
	}

	//	returns a specific row of the current subarray
	public Vector getCurrentSubTableVector(int row) {
		//Check for end of Vector
		if (row >= retSubVec.size()) {
			// If there is no more data, return a blank
			return null;
		}
		Vector data = (Vector) retSubVec.get(row);
		return data;
	}

	/**
	 * used to set the MI homefolder from the main application
	 */
	public void setMiHomeFolder(String string) {
		miHomeFolder = string;
	}

	public String getMiHomeFolder() {
		return miHomeFolder;
	}

	/*	public void setValueofIndex(int rowIndex, int colIndex, String value) {
			Vector data = (Vector) retVector.get(rowIndex);
			data.set(colIndex, value);
			retVector.set(rowIndex, data);
		} */

	public String getTableHeaderName(int col) {
		return dbAccess.getTableHeaderName(col);
	}

	public int getColumns() {
		return columns;
	}

	public static void setColumns(int col) {
		columns = col;
	}
	/**
	 * @returns the header vector
	 */
	public Vector getTableHeader() {
		return tableHeaderNamesToDisplay;
	}

	// Definition of table header
	public void initTableHeader(int noFields) {
		tableHeaderNamesToDisplay = new Vector();
		for (int i = 0; i < noFields; i++) {
			tableHeaderNamesToDisplay.add(" ");
		}
	}

	public void setTableHeader(Vector vector) {
		tableHeaderNamesToDisplay = vector;
	}

	public void setTableHeaderEntry(int col, String entry) {
		tableHeaderNamesToDisplay.set(col, entry);
	}
	/**
	 * @returns the number of the rows of the currently displayed table
	 */
	public int getTableRows() {
		return tablerows;
	}

	public String getHeaderContent(int column) {
		if (tableHeaderNamesToDisplay.get(column) == null) {
			return null;
		} else {
			return tableHeaderNamesToDisplay.get(column).toString();
		}
	}

	/**
	* sets the number of the rows of the currently displayed table
	* 	 */
	public void setTableRows(int i) {
		tablerows = i;
	}

	public int getTableColumns() {
		return tablecolumns;
	}

	public void setTableColumns(int col) {
		tablecolumns = col;
	}

	/**
	 * @param i sets all rows available in the dataset
	 */
	public void setRowsInDataset(int i) {
		rows_in_dataset = i;
	}
	public int getRowsInDataset() {
		return rows_in_dataset;
	}

	/**
	 * @return the current page of the selected data set - the page size is define in Constants.java
	 * variable: MAX_TABLE_ROWS
	 */

	public int getCurrentIndex() {
		return current_index;
	}

	public void setCurrentIndex(int i) {
		current_index = i;
	}

	/**
	 * @param synckey - syncbo key of entry
	 * @param newValue - new value for entry
	 * @param col - column index which has to be changed
	 */
	public void modifyEntry(String synckey, String newValue, int col) {
		dbAccess.modifyRowInDB(null, synckey, newValue, col);
	}
}
