package printerAPIExample1;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.sap.ip.me.api.runtime.jsp.AbstractMEHttpServlet;

import printerAPIExample1.bean.dataBean;

// Uses the MI print API to print a text string. The printer API is used in the printer.jsp file
// The servlet implementation just calls printer.jsp.
// You have to start the emulator first before you start the example - otherwise you get an exception.

public class PrintServlet extends AbstractMEHttpServlet implements Constants  {
  private dataBean servletToJSPBean;
  private String headLine;
  

/**
 * Return the name of the application
 */
  public String getApplicationName() {
       return MI_APPLICATION_NAME;
  }

/**
 * doIntialize - called when the servlet is activated the first time
 */
  public void doInitialize() throws ServletException {
  }

/**
 * doHandleEvent - called any subsequent time when an event on the web client occurs.
 */

  public String doHandleEvent(String eventName, HttpServletRequest request, HttpServletResponse response)  throws ServletException, IOException 
  {
// Set the name of the JSP that has to be called when this method is finished.
// INITIAL_JSP ist defined in the interface Constants.java
// This example has no events to take care of.
    String nextJSP = INITIAL_JSP;

// Set default text for headline
    headLine = INITIAL_MESSAGE;

// Get bean, if there is one, in the session context, otherwise create a new instance.
    getBeansFromContext(request);

// Load bean with values.
    loadBean(request);

// Put bean in the session context.
    putBeansIntoContext(request);

// Exit with name of JSP.
    return nextJSP;
  }

  
  private void getBeansFromContext(HttpServletRequest request)
  {
// Get bean from session context. There is a bean, when this servlet has already been called once.
	    servletToJSPBean = (dataBean) request.getSession().getAttribute("servletToJSPBean");

// No bean in session context - create a new instance.
		if (servletToJSPBean == null) servletToJSPBean = new dataBean ();
  }
   
  public void loadBean(HttpServletRequest request)
  {
       servletToJSPBean.setString(headLine);       
  }			


  private void putBeansIntoContext(HttpServletRequest request)
  {
// Put bean in session context
		if (servletToJSPBean == null)
		{ request.getSession().removeAttribute("servletToJSPBean"); 
		} else {
    	    request.getSession().setAttribute("servletToJSPBean", servletToJSPBean); }
  }

} 

