package persistenceexample1.datafactory;
import com.sap.ip.me.api.persist.app.PersistableEntity;
import com.sap.ip.me.api.persist.core.PersistenceContainer;
/**
 *  License Entity - represents the license number of a car
 *
 */

public class License implements PersistableEntity {

  final static String CLASSTYPE = "License";

  public PersistenceContainer getPersistedObject() {
	return this.obj;
  }

  private final PersistenceContainer obj;

  /**
   *  Constructor for the License object
   *
   *@param  entityKey  Description of the Parameter
   */
  License(PersistenceContainer obj) {
	this.obj = obj;
  }


  /**
   *  Gets the entityKey attribute of the Licence object
   *
   *@return    The entityKey value
   */
  public String getEntityKey() {
    return this.obj.getKey();
  }


  /**
   *  Gets the classtype attribute of the License object
   *
   *@return    The classtype value
   */
  public String getClasstype() {
    return CLASSTYPE;
  }


  
  public String toString() {
  	String rawText = this.obj.getKey().toString();
// Convert String into HTML compliant string
    return rawText;
  }
}
