package persistenceexample1;
import java.io.IOException;
import java.util.Vector;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import persistenceexample1.bean.TableViewBean;
import persistenceexample1.datafactory.ReadWriteEntities;

import com.sap.ip.me.api.logging.AbstractLogging;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Severities;
import com.sap.ip.me.api.runtime.jsp.AbstractMEHttpServlet;

// Uses the Peristence API to store and read data

public class PersistenceExample extends AbstractMEHttpServlet implements Constants {
	private TableViewBean tableViewBean;
	private String headLine;
	private boolean listall;
	private String buttontext;
	/**
	 * Must be overwritten - return the name of the application
	 */
	public String getApplicationName() {
		return MI_APPLICATION_NAME;
	}

	/**
	 * doIntialize - called when the servlet is activated the first time
	 */
	public void doInitialize() throws ServletException {
		//    setResourceBundle("/NoResourceBundleUsed");

		// Setup and initialize the Persistence Runtime
		ReadWriteEntities.setupPersistenceRuntime();

		// We create initial entries with the Persistence API, so that we have not to display an emtpy table
		ReadWriteEntities.writeExampleEntries();

		// Set list parameter to list only main entries
		setListPartial();
		//	Prepare a log output - Level DEBUG - Information about classloader
		ClassLoader cl = getClass().getClassLoader();
		AbstractLogging aLogger = AppLog.getInstance(MI_APPLICATION_NAME);
		aLogger.log(Severities.DEBUG, "MIClientInfo: Create MIClientInfoServlet.doInitialize with Classloader {0}", (cl == null ? "(null)" : cl.toString()));
	}

	/**
	 * doHandleEvent - called any subsequent time when an event on the web client occurs.
	 */

	public String doHandleEvent(String eventName, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// Set the name of the JSP that has to be called when this method is finished.
		// INITIAL_JSP ist defined in the interface Constants.java and refers to welcome.jsp. This JSP displays a welcome message
		// and asks for your name. Welcome.jsp has a submit button which generates the event EVENT_NAME. When this event occurs,
		// the tableView.jsp is called and displays system information.
		// The welcome.jsp is called by default - if the servlet is called the first time or an unknown event occurs.

		// Set default JSP.
		String nextJSP = INITIAL_JSP;
		// Set default text for headline
		headLine = WELCOME_MESSAGE;

		// Get bean, if there is one, in the session context, otherwise create a new instance.
		getBeansFromContext(request);

		//
		// Events in menu.jsp
		//
		if (eventName.equals(EVENT_ADDENTRY)) {
			// Event occurs when the ADD button in menu.jsp has been pressed.
			// We display add.jsp as next JSP.
			nextJSP = ADD_JSP;
		}

		if (eventName.equals(EVENT_LIST)) {
			// Toggle on listall (boolean) - if acutally true than set to false and vice versa
			if (listall == true) {
				setListPartial();
			} else {
				setListAll();
			}
		}

		if (eventName.equals(EVENT_DELENTRY)) {
			// Event occurs when the DELETE button in menu.jsp has been pressed.
			nextJSP = deleteEntry(request);
		}

		if (eventName.equals(EVENT_SAVE)) {
			// Event occurs when the SAVE button in menu.jsp has been pressed. It commits the changes in the database
			ReadWriteEntities.commit();
		}
		
		//
		// Events from add.jsp or delete.jsp (Cancel event - is handled the same for both JSP
		//
		if (eventName.equals(EVENT_ADDENTRYCANCEL)) {
			// Event occurs when the cancel button has been pressed on the ADD ENTRY JSP. No action. Show initial screen
			nextJSP = INITIAL_JSP;
		}

		//
		// Events in add.jsp
		//

		if (eventName.equals(EVENT_ADDENTRYSUBMIT)) {
			// Event occurs when the submit button has been pressed on the ADD ENTRY JSP
			nextJSP = addEntry(request);
		}

		//
		// Event in delete.jsp - is the OK button to acknowledge the information text
		//
		if (eventName.equals(EVENT_DELETEENTRYSUBMIT)) {
			nextJSP = INITIAL_JSP;
		}

		// Load bean with values from persistence layer
		loadBean(listall);

		// Put bean in the session context.
		putBeansIntoContext(request);

		// Exit with name of JSP.
		return nextJSP;
	}

	/**
	 * @param request
	 * @return
	 */
	private String addEntry(HttpServletRequest request) {		
		// Event occurs when the submit button has been pressed on the ADD ENTRY JSP
		// We take the content of the inputfield in the JSP named CAR and LICENCE and store in via the Peristence API
		// As next JSP we set the INITIAL_JSP again.
		String car = (String) request.getParameter("CAR");
		String lic = (String) request.getParameter("LICENSE");

		ReadWriteEntities.addEntity(car, lic);

		return INITIAL_JSP;
	}

	/**
	 * @param request
	 * @return
	 */
	private String deleteEntry(HttpServletRequest request) {
			
		// Event occurs when the DELETE button in menu.jsp has been pressed. We loop through all entries and check
		// which row has been selected. If we find a selected row we delete the entry.
		// We use the request.getParameter(valueOfCheckbox) method to find out which checkbox is clicked. The valueOfCheckbox
		// is stored in the first column of the databean.
		// If no row is selected we display a hint to select a row first.
		boolean aRowWasChecked = false;
		for (int i = 1; i < tableViewBean.getTableRows(); i++) {
			String check = (String) request.getParameter(tableViewBean.getTableContent(i, 0));
			if (check != null) {
				// Check Row has been found
				aRowWasChecked = true;
				String car = tableViewBean.getTableContent(i, 1);

				// Delete car. License is deleted also, because we use TreeOptionType.COMPLETE in the deleteEntity method
				if (car.length() > 0) {
					ReadWriteEntities.deleteEntity(car);
				}
			}
		}

		String nextJSP = INITIAL_JSP;
		if (aRowWasChecked == false) {
			// no row was checked - display an information message
			nextJSP = DELETE_JSP;
		}
		return nextJSP;
	}

	private void getBeansFromContext(HttpServletRequest request) {
		// Get bean from session context. There is a bean, when this servlet has already been called once.
		tableViewBean = (TableViewBean) request.getSession().getAttribute(CONTEXT_BEAN);

		// No bean in session context - create a new instance.
		if (tableViewBean == null)
			tableViewBean = new TableViewBean();
	}

	public void loadBean(boolean all) {
		// Set headline
		tableViewBean.setString(headLine);

		// Set button text for list button
		tableViewBean.setButton(buttontext);

		// Read all entities or only Car entities according to the setting of the "all" flag.
		Vector ent = new Vector();

		Vector dataVec = new Vector();
		dataVec.addElement(" ");
		dataVec.addElement("Car");
		dataVec.addElement("License");
		ent.addElement(dataVec);

		ent = ReadWriteEntities.readEntity(ent, all);

		tableViewBean.setTableContent(ent);
		tableViewBean.setTableRows(ent.size());
		tableViewBean.setTableColumns(3);
	}

	private void putBeansIntoContext(HttpServletRequest request) {
		// Put bean in session context
		if (tableViewBean == null) {
			request.getSession().removeAttribute(CONTEXT_BEAN);
		} else {
			request.getSession().setAttribute(CONTEXT_BEAN, tableViewBean);
		}
	}

	public void setListPartial() {
		listall = false;
		buttontext = " List all ";
	}

	public void setListAll() {
		listall = true;
		buttontext = "Short List";
	}
}