package persistenceexample3.bean;

import java.util.Vector;

/**
 * A bean used as databag to transport data from a servlet to the JSP. The bean contains a string
 * that can be used as title/headline for the JSP and 2 dimensional string array that contains the
 * data that should be displayed in the JSP in tabular form.
 * The int values tableRows and tableColumns should be set to the actual dimension of the array.
 * The JSP uses the two values to iterate.
 */
public class TableViewBean {

// name is used as title in the JSP
    private String name;
    private String button;
    private String button_query;
	// array for table    
	private Vector tableContent;
	// variables that define the size of the array
	private int tableColumns;
	private int tableRows;

// get and set methods
    public String getString ()
    {
        return this.name;
    }
    public void setString (String name)
    {
        this.name = name;
    }

	/**
	 * Returns the button.
	 * @return String
	 */
	public String getButton() {
		return button;
	}

	/**
	 * Sets the button.
	 * @param button The button to set
	 */
	public void setButton(String button) {
		this.button = button;
	}

	/**
	 * Returns the button_query.
	 * @return String
	 */
	public String getButtonQuery() {
		return button_query;
	}

	/**
	 * Sets the button_query.
	 * @param button_query The button_query to set
	 */
	public void setButtonQuery(String button_query) {
		this.button_query = button_query;
	}

	public void setTableColumns(int columns) {
		this.tableColumns = columns;
	}

	public void setTableRows(int rows) {
		this.tableRows = rows;
	}

	public int getTableColumns() {
		return this.tableColumns;
	}

	public int getTableRows() {
		return this.tableRows;
	}

	public String getTableContent(int row, int column) {
		Vector data = (Vector) tableContent.get(row);
		return data.get(column).toString();
	}


	public Vector getTableContent() {
		return tableContent;
	}

	public void setTableContent(Vector vector) {
		tableContent = vector;
	}
}
