package persistenceexample4.bean;

import java.util.Iterator;
import java.util.Vector;

import persistenceexample4.Constants;

/**
 * A bean used as databag to transport data from a servlet to the JSP. The bean contains a string
 * that can be used as title/headline for the JSP, the header and footer information and a vector
 * that contains the headline and data for the JSP to display in tabular form.
 * The int values tableRows and tableColumns should be set to the actual dimension of the array.
 * The JSP uses the two values to iterate.
 */
public class TableViewDefinition implements Constants {

	private int maxPage;
	// array for table    
	private Vector tableContent;
	private Vector tableHeader;
	// Header and footer panel
	private Vector headerPanel;
	private Vector footerPanel;
	// Command line
	private Vector commandLine;

	// variables that define the size of the array
	private int currentPage;
	private int current_index;
	private int selected_index;
	private int rows_in_dataset;
	private int tablerows;
	private int tablecolumns;
	private String centerPageTitle;
	private String formName;

	// get and set methods for the gui
	// Header. Header is a vector that contains two text strings which are displayed on the left and
	// and right handside. The Header is displayed on the top of the aplication.
	// Footer. Similar to header. The footer is displayed on the bottom of the application.
	// 
	public Vector getFooterPanel() {
		return footerPanel;
	}

	public String getFooterPanelEntryLeft() {
		return footerPanel.get(0).toString();
	}

	public String getFooterPanelEntryRight() {
		return footerPanel.get(1).toString();
	}

	public void setFooterPanelEntryLeft(String entry) {
		if (footerPanel == null)
			initFooterPanel();
		footerPanel.set(0, entry);
	}

	public void setFooterPanelEntryRight(String entry) {
		if (footerPanel == null)
			initFooterPanel();
		footerPanel.set(1, entry);
	}

	public void initFooterPanel() {
		if (footerPanel == null) {
			footerPanel = new Vector();
			footerPanel.add(" ");
			footerPanel.add(" ");
		}
	}

	public void initHeaderPanel() {
		if (headerPanel == null) {
			headerPanel = new Vector();
			headerPanel.add(" ");
			headerPanel.add(" ");
		}
	}

	public Vector getHeaderPanel() {
		return headerPanel;
	}

	public String getHeaderPanelEntryLeft() {
		return headerPanel.get(0).toString();
	}

	public String getHeaderPanelEntryRight() {
		return headerPanel.get(1).toString();
	}

	public void setHeaderPanelEntryLeft(String entry) {
		if (headerPanel == null)
			initHeaderPanel();
		headerPanel.set(0, entry);
	}

	public void setHeaderPanelEntryRight(String entry) {
		if (headerPanel == null)
			initHeaderPanel();
		headerPanel.set(1, entry);
	}

	public void setFooterPanel(Vector vector) {
		footerPanel = vector;
	}

	public void setHeaderPanel(Vector vector) {
		headerPanel = vector;
	}

	public String getHeaderContent(int column) {
		return tableHeader.get(column).toString();
	}

	public String getCenterPageTitle() {
		return centerPageTitle;
	}

	public void setCenterPageTitle(String title) {
		centerPageTitle = title;
	}

	public String getCommandLine(String separator) {
		Iterator dataIterator = commandLine.iterator();
		String commandLineString = "";
		int i = 0;
		while (dataIterator.hasNext()) {
			if (commandLineString.length() > 1)
				commandLineString = commandLineString.concat(separator);
			commandLineString = commandLineString.concat((String) dataIterator.next());
		}

		return commandLineString;
	}

	public void setCommandLine(Vector commands) {
		commandLine = commands;
	}

	public void addCommand(String command) {
		commandLine.add(command);
	}

	/**
	 * @param i sets all rows available in the dataset
	 */
	public void setRowsInDataset(int i) {
		rows_in_dataset = i;
	}
	public int getRowsInDataset() {
		return rows_in_dataset;
	}

	/*
	 * Returns the HTML code for the navigation buttons in the JSP
	 * If a icon is disabled, it displays only the icon - no event will be fired
	 * If the icon is enabled it displays the icon and generated a href statement for the event
	 */

	public boolean isTopPrevPagesAvailable() {
		boolean ret = false;
		if (current_index >= MAX_TABLE_ROWS) {
			ret = true;
		}
		return ret;
	}
	public boolean isNextLastPageAvailable() {
		boolean ret = false;
		if (rows_in_dataset > (tablerows + current_index))
			ret = true;
		return ret;
	}

	public String getTopIcon() {
		String event = "";
		String icon = ICON_FIRSTPAGE_DISABLED;
		if (isTopPrevPagesAvailable()) {
			icon = ICON_FIRSTPAGE_ENABLED;
			event = " href=\"?event=" + EVENT_FIRSTPAGE + "\"";
		}
		String ret = "<a" + event + "><img src=\"" + icon + "\" alt=\"First page\" ></a>";
		return ret;
	}

	public String getBottomIcon() {
		String event = "";
		String icon = ICON_LASTPAGE_DISABLED;
		if (isNextLastPageAvailable()) {
			icon = ICON_LASTPAGE_ENABLED;
			event = " href=\"?event=" + EVENT_LASTPAGE + "\"";
		}
		String ret = "<a" + event + "><img src=\"" + icon + "\" alt=\"Last page\" ></a>";
		return ret;
	}

	public String getPageupIcon() {
		String event = "";
		String icon = ICON_PAGEUP_DISABLED;
		if (isTopPrevPagesAvailable()) {
			icon = ICON_PAGEUP_ENABLED;
			event = " href=\"?event=" + EVENT_PAGEUP + "\"";
		}
		String ret = "<a" + event + "><img src=\"" + icon + "\" alt=\"Page up\" ></a>";
		return ret;
	}

	public String getPagedownIcon() {
		String event = "";
		String icon = ICON_PAGEDOWN_DISABLED;
		if (isNextLastPageAvailable()) {
			icon = ICON_PAGEDOWN_ENABLED;
			event = " href=\"?event=" + EVENT_PAGEDOWN + "\"";
		}
		String ret = "<a" + event + "><img src=\"" + icon + "\" alt=\"Page down\" ></a>";
		return ret;
	}

	public String getGotoIcon() {
		/* the goto icon is created as submit button so that the form is submitted and we have access to the input fields
		 * The "input" tag with type = image in menu.jsp returns the eventname with .x and .y appended to it. So the event 
		 * handler checks only the beginning of the eventname.
		 
		 * Alternative is the button tag. The button tag send the event name without .x and .y
		 * Example:		
			   String ret = "<button type=\"submit\" value=\"gotoButton\" class=\"image\" name=\"" + EVENT_GOTOPAGE + "\"><img src=\"" + ICON_GOTO_PAGE + "\" alt=\"go to page\" ></button>";
		 * Disadvantage of the button tag is that it is not available on all browsers.
		 */
		String ret = "<input type=\"image\" value=\"\" class=\"image\" name=\"_event_" + EVENT_GOTOPAGE + "\" title=\"Go to selected page\" src=\"" + ICON_GOTO_PAGE + "\" alt=\"go to page\" >";
		return ret;
	}

	/**
	 * @returns the header vector
	 */
	public Vector getTableHeader() {
		return tableHeader;
	}

	// Definition of table header
	public void initTableHeader(int noFields) {
		tableHeader = new Vector();
		for (int i = 0; i < noFields; i++) {
			tableHeader.add(" ");
		}
	}

	public void setTableHeader(Vector vector) {
		tableHeader = vector;
	}

	public void setTableHeaderEntry(int col, String entry) {
		tableHeader.set(col, entry);
	}
	/**
	 * @returns the number of the rows of the currently displayed table
	 */
	public int getTableRows() {
		return tablerows;
	}

	/**
	* sets the number of the rows of the currently displayed table
	* 	 */
	public void setTableRows(int i) {
		tablerows = i;
	}

	public int getTableColumns() {
		return tablecolumns;
	}

	public void setTableColumns(int col) {
		tablecolumns = col;
	}

	/**
	 * @return the current page of the selected data set - the page size is define in Constants.java
	 * variable: MAX_TABLE_ROWS
	 */
	public int getCurrentPage() {
		currentPage = (current_index / MAX_TABLE_ROWS) + 1;
		return currentPage;
	}

	public void setCurrentPage(int i) {
		currentPage = i;
	}

	public int getCurrentIndex() {
		return current_index;
	}

	public void setCurrentIndex(int i) {
		current_index = i;
	}

	/**
	 * @return the maximum pages for the data set - the page size is define in Constants.java
	 * variable: MAX_TABLE_ROWS
	 */
	public int getMaxPage() {
		maxPage = 1;
		if (rows_in_dataset != 0) {
			maxPage = ((rows_in_dataset - 1) + MAX_TABLE_ROWS) / MAX_TABLE_ROWS;
		}
		return maxPage;
	}

	public void setMaxPage(int i) {
		maxPage = i;
	}

	/**
	 * @return the form name of the HTML page generated in the JSP
	 */
	public String getFormName() {
		return MI_FORM_NAME;
	}
	public String getEventID() {
		return MI_EVENT_ID;
	}
	public String getEventType() {
		return MI_EVENT_TYPE;
	}
	public String getEventObject() {
		return MI_EVENT_OBJECT;
	}

	/**
	 * @return the indexnumbers to access the Vectore
	 */
	public int getIndexMake() {
		return I_MAKE;
	}
	public int getIndexModel() {
		return I_MODEL;
	}
	public int getIndexCylinder() {
		return I_CYLINDER;
	}
	public int getIndexEngine() {
		return I_ENGINE;
	}
	public int getIndexLicense() {
		return I_LICENSE;
	}
	public int getIndexValves() {
		return I_VALVES;
	}
	/**
	 * @return the currently selected index
	 */
	public int getSelected_index() {
		return selected_index;
	}

	/**
	 * @param i sets the currently selected index
	 */
	public void setSelected_index(int i) {
		selected_index = i;
	}

}
