package persistenceexample4.bean;

import java.util.Iterator;
import java.util.Vector;

import persistenceexample4.Constants;
import persistenceexample4.datafactory.ReadWriteEntities;

public class BasicDataHandler implements Constants {
	private static int columns;
	private static Vector retVector;
	private Vector retSubVec;
	private static BasicDataHandler bdh = null;
	private static boolean listall;
	private static int filter_index;
	private static int sort_index;
	private static boolean sort_ascending;
	private static String filter_string;
	private static int currentPage;
	private static int currentIndex;
	private static int start_index;
	private static int recCount;

	private static String miHomeFolder;

	public static BasicDataHandler instance(int index, int sortIndex, boolean sort_type, String obj, boolean all) {
		if (bdh == null)
			bdh = new BasicDataHandler();
		filter_index = index;
		sort_index = sortIndex;
		sort_ascending = sort_type;
		listall = all;
		filter_string = obj;

		generateData();
		return bdh;
	}
	/**
	 * Method creates the demodata to be displayed
	 */
	private static void generateData() {
		// Read data from persistence layer according to filter settings and append it to the header.
		retVector = new Vector();
		columns = 4;
		retVector = ReadWriteEntities.readEntity(retVector, filter_index, sort_index, sort_ascending, filter_string, listall);
	}

	private String stringLoad(String var) {
		// This method checks if a String is null - if so, it uses a standard text
		String vartmp = var;
		if (vartmp == null)
			vartmp = "Not available";

		return vartmp;
	}

	//	creates  a subarray of the full dataset defined by a start index and the number of rows
	//  The result is returned and also kept locally as retSubVec to be retrieved by the bean
	public Vector getDataArray(int fromIndex, int count) {
		recCount = count;
		start_index = fromIndex;

		retSubVec = new Vector();
		Iterator dataIterator = retVector.iterator();
		int i = 0;
		Vector dataEntry = null;
		while (dataIterator.hasNext()) {
			dataEntry = (Vector) dataIterator.next();
			if (i >= fromIndex) {
				retSubVec.add(dataEntry);
			}
			i++;
			// Return when count has been reached			
			if (i >= (fromIndex + count))
				return retSubVec;
		}
		// Return - there are less than required data in the Vector
		return retSubVec;
	}

	public void copyDataArrayToSubArray(int fromIndex, int count) {
		recCount = count;
		start_index = fromIndex;

		retSubVec = new Vector();
		Iterator dataIterator = retVector.iterator();
		int i = 0;
		Vector dataEntry = null;
		while (dataIterator.hasNext()) {
			dataEntry = (Vector) dataIterator.next();
			if (i >= fromIndex) {
				retSubVec.add(dataEntry);
			}
			i++;
			// Return when count has been reached			
			if (i >= (fromIndex + count))
				return;
		}
	}

	//	returns a specific entry of the current subarray
	public void addEntry(String make, String model, String eng, String cyl, String valv, String lic) {
		ReadWriteEntities.addEntity(make, model, eng, cyl, valv, lic);
	}

	//	delete entry
	public void delEntry(String id) {
		ReadWriteEntities.deleteEntity(id);
	}

	//	saves all entries in the database
	public void commit() {
		ReadWriteEntities.commit();
	}

	// returns the current subarray that has been created with getDataArray
	public Vector getCurrentSubArray() {
		return retSubVec;
	}

	//	returns a specific entry of the current subarray
	public String getCurrentSubTableContent(int row, int column) {
		//Check for end of Vector
		if (row >= retSubVec.size()) {
			// If there is no more data, return a blank
			return BLANK_VALUE;
		}
		Vector data = (Vector) retSubVec.get(row);
		return data.get(column).toString();
	}

	//	returns a specific entry specified by id
	public Vector getEntry(String id, int prev) {
		Iterator dataIterator = retVector.iterator();
		Vector dataEntry = null;
		Vector dataPrevEntry = null;
		Vector retVec = null;
		currentIndex = 0;
		while (dataIterator.hasNext()) {
			currentIndex++;
			dataEntry = (Vector) dataIterator.next();
			if (dataEntry.get(0).toString().compareTo(id) == 0) {
				if (prev == 0) {
					retVec = dataEntry;
					return retVec;
				}
				// take prev entry
				if (prev == -1) {
					if (dataPrevEntry != null) {
						currentIndex--;
						return dataPrevEntry;
					} else {
						return dataEntry;
					}
				}
				// take next entry
				if (prev == 1) {

					if (dataIterator.hasNext()) {
						currentIndex++;
						retVec = (Vector) dataIterator.next();
						return retVec;
					} else {
						return dataEntry;
					}
				}
			}
			dataPrevEntry = dataEntry;
		}
		return retVec;
	}

	//	returns a the first id of the array
	public String getFirstEntryID() {
		Vector dataEntry = (Vector) retVector.get(0);
		return dataEntry.get(0).toString();
	}

	//	returns a the first id of the array
	public String getLastEntryID() {
		Vector dataEntry = (Vector) retVector.get(retVector.size()-1);
		return dataEntry.get(0).toString();
	}

	public String getNextEntryID() {
		Vector dataEntry = (Vector) retVector.get(0);
		return dataEntry.get(0).toString();
	}

	//	returns a the first id of the array
	public String getPrevEntryID() {
		Vector dataEntry = (Vector) retVector.get(retVector.size());
		return dataEntry.get(0).toString();
	}

	//	returns a specific row of the current subarray
	public Vector getCurrentSubTableVector(int row) {
		//Check for end of Vector
		if (row >= retSubVec.size()) {
			// If there is no more data, return a blank
			return null;
		}
		Vector data = (Vector) retSubVec.get(row);
		return data;
	}

	public Vector getDataArray() {
		return retVector;
	}

	public int getDataCount() {
		return retVector.size();
	}

	public int getCurrentEntry() {
		return currentIndex;
	}
	/**
	 * used to set the MI homefolder from the main application
	 */
	public void setMiHomeFolder(String string) {
		miHomeFolder = string;
	}

	public String getMiHomeFolder() {
		return miHomeFolder;
	}

	public void setValueofIndex(int rowIndex, int colIndex, String value) {
		Vector data = (Vector) retVector.get(rowIndex);
		data.set(colIndex, value);
		retVector.set(rowIndex, data);
	}

	public int getColumns() {
		return columns;
	}
}
