package persistenceexample4.page;

import java.awt.Component;
import java.awt.Image;
import java.awt.TextField;
import java.util.Iterator;
import java.util.Vector;

import persistenceexample4.Constants;

import com.sap.ip.me.mdk.api.awt.gui.component.ComponentConstants;
import com.sap.ip.me.mdk.api.awt.gui.component.LinkButton;
import com.sap.ip.me.mdk.api.awt.gui.component.TextLabel;
import com.sap.ip.me.mdk.api.awt.gui.page.ControllerPage;
import com.sap.ip.me.mdk.api.awt.gui.page.DetailListPage;
import com.sap.ip.me.mdk.api.awt.gui.util.NavHelper;
import com.sap.ip.me.mdk.api.awt.gui.util.Utilities;
/**
 * This class is to display the details of a car
 */
public class DetailList extends DetailListPage implements Constants {
	//private static final String headerMsg = " Car/License";

	private static final String footerMsg = "Page";
	private static final String headerTitle = "Car inventory: ";

	private Vector data = null;
	private NavHelper navHelper = null;
	protected LinkButton   characterNavLink = null;
	protected LinkButton[] characterNavLinks = null;

	private LinkButton[] tableNavListLink = null;
	private LinkButton[] tableLink = null;
	private TextLabel[] tableDescription = null;
	private LinkButton[] tableHeaderLink = null;
	private TextLabel[] tableHeaderDescription = null;
	private TextField tfCurrentPage = null;
	private TextLabel tlPageString = null;
	private TextLabel tlTotalPage = null;
	private LinkButton gotoPage = null;
	private Image imgPlay = ComponentConstants.getImage(ComponentConstants.iconPlay);
	private String[] tableHeaderLines = { "  Make/Model  ", "License           " };

	public DetailList(ControllerPage mainPage) {
		super(mainPage.getActionHandler());

		// Get entries for character navigation
		String[] charsNav = (String[])getAttribute(ATTR_CHARS_NAV);
		// Create Links for character navigation
		characterNavLinks = new LinkButton[charsNav.length];
		for(int i=0; i<characterNavLinks.length; i++){
			characterNavLinks[i] = new LinkButton(charsNav[i]);
			characterNavLinks[i].addMouseListener(actionHandler);
			characterNavLinks[i].setTargetPage(Constants.TP_CARHOME,Constants.TP_DETAILLIST, charsNav[i]);
			characterNavLinks[i].setTargetHandler(Constants.HND_SHOWLIST, Constants.HND_CHARACTERLIST, charsNav[i]);
			characterNavLinks[i].setName(charsNav[i].toString());
		}
		// Call methode - which add the Links (characters) in a Panel
		this.setCharacterNavLinks(characterNavLinks);

		tfCurrentPage = ComponentConstants.createTextField(1, 3, true);
		tfCurrentPage.setSize(tfCurrentPage.getSize().width / 2, tfCurrentPage.getSize().height * 2 / 3);
		tlPageString = new TextLabel(footerMsg);
		tlTotalPage = new TextLabel("/??");
		gotoPage = ComponentConstants.createImageButton(imgPlay, "", Constants.HND_GETPAGE);
		gotoPage.addMouseListener(actionHandler);
	}
	/**
	 * Method setCharacterNavLinks.- fill in actionBar all wanted characters
	 */
	  public void  setCharacterNavLinks(LinkButton[] links) {
		  if (links != null && links.length > 0)
			  actionBar.addToLeft(links);
	  }

	public void initializePage() {
		String[] pgHandlers = { Constants.HND_FIRSTPAGE, Constants.HND_PREVPAGE, Constants.HND_NEXTPAGE, Constants.HND_LASTPAGE };
		this.setPageNavHandlers(pgHandlers);
		this.setCreateActionAttributes(Constants.TP_CARCREATE, Constants.HND_SHOWCARCREATE);
		this.setPagingContols(new Component[] { tlPageString, tfCurrentPage, tlTotalPage, gotoPage });
	}
	public Object getObject() {
		if (Utilities.isNumber(tfCurrentPage.getText())) {
			int n = Integer.parseInt(tfCurrentPage.getText());
			if (n < 1)
				NavHelper.PG_CURPAGE = 1;
			else if (n > NavHelper.PG_PAGECOUNT)
				NavHelper.PG_CURPAGE = NavHelper.PG_PAGECOUNT;
			else
				NavHelper.PG_CURPAGE = n;
		}
		return navHelper;
	}
	public void destroyPage() {
		this.clearAttributes();
	}
	public void updatePage() {

		navHelper = (NavHelper) getAttribute(ATTR_NAVHELPER);
		data = (Vector)getAttribute(ATTR_OBJECTLIST);
		//BasicDataHandler dataHandler = new BasicDataHandler();
		//data = dataHandler.getDataArray(Utilities.getStartIndex(), Utilities.getListCount());

		this.setHeaderTexts(new String[] { headerTitle+(String)this.getAttribute(ATTR_CUR_NAV_CHAR)  });

		tfCurrentPage.setText("" + NavHelper.PG_CURPAGE);
		tlTotalPage.setLabel("/" + NavHelper.PG_PAGECOUNT);

		//this.setActionBarMessage(NavHelper.PG_RECCOUNT + headerMsg);
		//this.setFooterMessage(footerMsg + navHelper.PG_CURPAGE + "/" + navHelper.PG_PAGECOUNT);

		if (NavHelper.PG_TOPPREV)
			this.enableFirstPrevPageNav();
		else
			this.disableFirstPrevPageNav();
		if (NavHelper.PG_NEXTLAST)
			this.enableNextLastPageNav();
		else
			this.disableNextLastPageNav();

		int i = 0;
 		tableHeaderDescription = new TextLabel[1];
		tableHeaderLink = new LinkButton[1];
		tableHeaderLink[i] = new LinkButton(tableHeaderLines[0]);
		tableHeaderLink[i].addMouseListener(this.actionHandler);
		tableHeaderLink[i].setTargetPage(TP_CARHOME);
		tableHeaderLink[i].setTargetHandler(HND_SORTBYCAR);
		tableHeaderLink[i].setTextColor(ComponentConstants.linkHeaderColor);
		tableHeaderDescription[i] = new TextLabel(tableHeaderLines[1]);
		tableHeaderDescription[i].setTextColor(ComponentConstants.headerTextColor);
		this.setListHeader(tableHeaderLink, tableHeaderDescription);

		Iterator dataIterator = data.iterator();
		tableDescription = new TextLabel[data.size()];
		tableLink = new LinkButton[data.size()];

		Vector dataEntry = null;
		while (dataIterator.hasNext()) {
			dataEntry = (Vector) dataIterator.next();
			tableLink[i] = new LinkButton(dataEntry.elementAt(I_MAKE).toString() + "-" +
			                              dataEntry.elementAt(I_MODEL).toString());
			tableLink[i].addMouseListener(this.actionHandler);
			tableLink[i].setTargetPage(TP_CARDETAIL);
			tableLink[i].setTargetHandler(HND_SHOWCARDETAILS);
			tableLink[i].setName(dataEntry.elementAt(I_ID).toString());
			tableDescription[i] = new TextLabel(dataEntry.elementAt(I_LICENSE).toString());
			i++;
		}
		this.setList(tableLink, tableDescription);
		validate();
	}
}
