package persistenceexample4.page;
import java.util.Vector;

import persistenceexample4.Constants;

import com.sap.ip.me.mdk.api.awt.gui.component.LinkButton;
import com.sap.ip.me.mdk.api.awt.gui.component.TextLabel;
import com.sap.ip.me.mdk.api.awt.gui.page.ControllerPage;
import com.sap.ip.me.mdk.api.awt.gui.page.DetailPage;

import com.sap.ip.me.mdk.api.awt.gui.util.NavHelper;
import com.sap.ip.me.mdk.api.awt.gui.util.Utilities;

/**
 * @author i021268
 * 2003/04/01
 */

public class CarDetailPage extends DetailPage implements Constants {
	private Vector _currentCar = null;
	private NavHelper navHelper = null;

	private static final String headerTxt = "Details of: ";

	public static TextLabel tlCarID = new TextLabel(PageConstants.FLD_PFLDNAMES[0]);
	public static TextLabel tlManufacturer = new TextLabel(PageConstants.FLD_PFLDNAMES[1]);
	public static TextLabel tlModel = new TextLabel(PageConstants.FLD_PFLDNAMES[2]);
	public static TextLabel tlEngine = new TextLabel(PageConstants.FLD_PFLDNAMES[3]);
	public static TextLabel tlCylinders = new TextLabel(PageConstants.FLD_PFLDNAMES[4]);
	public static TextLabel tlValves = new TextLabel(PageConstants.FLD_PFLDNAMES[5]);
	public static TextLabel tlLicense = new TextLabel(PageConstants.FLD_PFLDNAMES[6]);

	private TextLabel tfCarID = null;
	private TextLabel tfManufacturer = null;
	private TextLabel tfModel = null;
	private TextLabel tfEngine = null;
	private TextLabel tfCylinders = null;
	private TextLabel tfValves = null;
	private TextLabel tfLicense = null;

	private TextLabel[] fieldNames = null;
	private TextLabel[] fieldValues = null;

	private LinkButton emailBtn = null;
	private LinkButton addrsBtn = null;
	private LinkButton[] subActions = null;

	public CarDetailPage(ControllerPage mainPage) {
		super(mainPage.getActionHandler());

		tfCarID = new TextLabel();
		tfManufacturer = new TextLabel();
		tfModel = new TextLabel();
		tfEngine = new TextLabel();
		tfCylinders = new TextLabel();
		tfValves = new TextLabel();
		tfLicense = new TextLabel();

		Utilities.print("CarDetailPage constructor.");
	}
	public void initializePage() {
		Utilities.print("CarDetailPage.initializePage called");
		this.setHeaderTexts(new String[] { headerTxt });
		fieldNames = new TextLabel[] { tlCarID, tlManufacturer, tlModel, tlEngine, tlCylinders, tlValves, tlLicense };
		fieldValues = new TextLabel[] { tfCarID, tfManufacturer, tfModel, tfEngine, tfCylinders, tfValves, tfLicense };
		this.setList(fieldNames, fieldValues);

		this.setDeleteActionAttributes(Constants.TP_CARHOME, Constants.HND_DELETECAR);
		this.setListActionAttributes(Constants.TP_CARDETAIL, Constants.HND_SHOWCARCREATE);
		Utilities.print("CarDetailPage.initializePage ended");
	}
	public void destroyPage() {
		Utilities.print("CarDetailPage.destroyPage called");
		this.clearAttributes();
		Utilities.print("CarDetailPage.destroyPage ended");
	}
	
	public Object getObject() {
		return _currentCar.get(I_ID).toString();
	}
	
	public void updatePage() {
		Utilities.print("CarDetailPage.updatePage called");
		navHelper = (NavHelper) getAttribute(ATTR_NAVHELPER);

		_currentCar = (Vector) getAttribute(ATTR_CUROBJECT);
		this.setHeaderTexts(new String[] { headerTxt + _currentCar.get(I_MAKE).toString() });

		tfCarID.setLabel(_currentCar.get(I_ID).toString());
		tfManufacturer.setLabel(_currentCar.get(I_MAKE).toString());
		tfModel.setLabel(_currentCar.get(I_MODEL).toString());
		tfEngine.setLabel(_currentCar.get(I_ENGINE).toString());
		tfCylinders.setLabel(_currentCar.get(I_CYLINDER).toString());
		tfValves.setLabel(_currentCar.get(I_VALVES).toString());
		tfLicense.setLabel(_currentCar.get(I_LICENSE).toString());
		validate();
		Utilities.print("CarDetailPage.updatePage ended");
		//Update targetPage from homeLink because it's a difference between Navigation All and the other characters
		homeLink.setTargetPage(Constants.TP_CARHOME, Constants.TP_DETAILLIST, (String) getAttribute(ATTR_CUR_NAV_CHAR));
		homeLink.setTargetHandler(Constants.HND_SHOWHOME, Constants.HND_CHARACTERLIST, (String) getAttribute(ATTR_CUR_NAV_CHAR));		
	}
}
