package com.sap.ip.me.mdk.api.awt.gui.util;

import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;

import com.sap.ip.me.api.logging.AbstractLogging;
import com.sap.ip.me.api.logging.Severities;

/**
 * General utilities.
 * This class contains methods to create components and defines the icons 
 * and color used in the user interface.
 */
public class Utilities {
	public static AbstractLogging aLogger;

	// Conversation constants
	private static SimpleDateFormat sdf = null;

	//encoding constants
	public static final String _ISO8859 = "ISO-8859-1";
	public static final String _SHIFTJIS = "Shift_JIS";
	public static final String _UTF8 = "UTF8";
	public static final String _UTF16 = "UTF16";
	public static final String _EUC = "EUC";

	public static final int n_UTF16 = 3;
	public static final int n_EUC = 4;
	public static final int n_ISO8859 = 0;
	public static final int n_UTF8 = 2;
	public static final int n_SJIS = 1;
	//element names
	//dbcs
	private static int ENCTYPE = 0; //0 for SJIS, 1for UTF, 2 is ISO, SJIS is the default value
	public static boolean DBCS_ENC = false;
	//page list variables
	private static int _startIndex = 0;
	private static int _listCount = 5;
	private static int _recCount = 0;

	//lang dependent
	private static String LD_DECIMAL_PT = "."; // [.] for english but [,] for german
	//date format
	private static String FT_DATEMODIFIED = "yyyy.MM.dd hh:mm:ss";
	//local temp key
	private static String FT_TEMPKEY = "MMddhhmmss";

	public static boolean isNumber(String t) {
		if (t == null || t.length() == 0)
			return false;
		try {
			Integer.parseInt(t);
			return true;
		} catch (NumberFormatException nfe) {
			return false;
		}
	}
	/**
	 * @return
	 */
	public static AbstractLogging getALogger() {
		return aLogger;
	}

	/**
	 * @param logging
	 */
	public static void setALogger(AbstractLogging logging) {
		aLogger = logging;
	}

	public static void print(String output) {
		aLogger.log(Severities.INFO, output);
	}

	public static void setEncType(int enc) {
		ENCTYPE = enc;
	}
	public static int getEncType() {
		return ENCTYPE;
	}
	public static boolean toggleDBCSEncoding(boolean val) {
		DBCS_ENC = val;
		return DBCS_ENC;
	}
	public static String encodeString(String inString) {
		if (inString == null)
			return null;
		if (!DBCS_ENC)
			return inString;
		String res = "";
		switch (ENCTYPE) {
			case n_SJIS : //SJIS
				res = encodeString(inString, _ISO8859, _SHIFTJIS);
				break;
			case n_UTF8 : //UTF8
				res = encodeString(inString, _ISO8859, _UTF8);
				break;
			case n_ISO8859 : //ISO
				res = encodeString(inString, _ISO8859, _ISO8859);
				break;
			case n_EUC : //EUC
				res = encodeString(inString, _ISO8859, _EUC);
				break;
			default : //default encoding
				res = inString;
				break;
		}
		return res;
	}
	private static String encodeString(String inString, String fromEnc, String toEnc) {
		if (inString == null)
			return null;

		String tString = "";
		try {
			if (fromEnc == null)
				tString = new String(inString.getBytes(), toEnc).trim();
			else
				tString = new String(inString.getBytes(fromEnc), toEnc).trim();
		} catch (UnsupportedEncodingException uee) {
			Utilities.print("CU: UnsupportedEncoding! (" + toEnc + ")");
		}
		return tString;
	}
	public static String encodeString(String inString, String toEnc) {
		return encodeString(inString, null, toEnc);
	}

	public static String byteToString(byte[] inByte, String enc) {
		String tString = "";
		try {
			tString = new String(inByte, enc).trim();
		} catch (UnsupportedEncodingException uee) {
		}

		return tString;
	}
	public static String byteToString(byte[] inByte) {
		return byteToString(inByte, getEncodingType());
	}
	public static String byteToString(byte[] inByte, int from, int len) {
		String tString = "";
		try {
			tString = new String(inByte, from, len, getEncodingType()).trim();
		} catch (UnsupportedEncodingException uee) {
		}
		return tString;
	}
	public static String encodeToDefaultEnc(String inString) {
		return encodeString(inString, null, getEncodingType());
	}
	public static String getEncodingType() {
		String enc = "";
		switch (ENCTYPE) {
			case n_SJIS : //SJIS
				enc = _SHIFTJIS;
				break;
			case n_UTF8 : //UTF8
				enc = _UTF8;
				break;
			case n_ISO8859 : //ISO
				enc = _ISO8859;
				break;
			case n_EUC : //EUC
				enc = _EUC;
				break;
			default : //default encoding
				enc = _SHIFTJIS;
				break;
		}
		return enc;
	}
	//list page variables getter & setter
	public static int getStartIndex() {
		return _startIndex;
	}
	public static void setStartIndex(int nIndex) {
		_startIndex = nIndex;
	}
	
	/**
	 * Set the number of records to display
	 */
	public static void set_recCount(int i) {
		_recCount = i;
	}

	public static int getListCount() {
		if (_listCount > (_recCount - _startIndex))
			return (_recCount - _startIndex);
		return _listCount;
	}
	public static int getPageLineCount() {
		return _listCount;
	}
	public static void setListCount(int nCount) {
		_listCount = nCount;
	}
	public static int getPageCount() {
		if (_recCount == 0)
			return 1;
		return ((_recCount - 1) + _listCount) / _listCount;
	}
	public static int getCurrentPageNumber() {
		return (_startIndex / _listCount) + 1;
	}
	//page markers
	public static void setTopPageIndex() {
		_startIndex = 0;
	}
	public static void setPrevPageIndex() {
		if (_startIndex >= _listCount)
			_startIndex = _startIndex - _listCount;
	}
	public static void setNextPageIndex() {
		_startIndex = _startIndex + _listCount;
	}
	public static void setLastPageIndex() {
		_startIndex = ((_recCount - 1) / _listCount) * _listCount;
	}
	public static void setDesiredPage(int pgNum) {
		_startIndex = (pgNum - 1) * _listCount;
	}
	public static boolean isTopPrevPagesAvailable() {
		if (_startIndex >= _listCount)
			return true;
		return false;
	}
	public static boolean isNextLastPageAvailable() {
		if (_recCount > (_listCount + _startIndex))
			return true;
		return false;
	}
	//could be [.] or [,] for the decimal char
	public static String getDecimalPointCharacter() {
		return LD_DECIMAL_PT;
	}
	public static void setDecimalPointCharacter(String decChar) {
		LD_DECIMAL_PT = decChar;
	}
	//get current time/data in long format
	public static String getCurrentDateTime() {
		sdf = new SimpleDateFormat(FT_DATEMODIFIED);
		return sdf.format(new Date());
	}
	public static String getLocalTempKey() {
		sdf = new SimpleDateFormat(FT_TEMPKEY);
		return sdf.format(new Date());
	}

	public static String createLeftFixedString(String inString, char prefix, int length) {
		return fixedString(inString, prefix, length, true);
	}
	public static String createRightFixedString(String inString, char prefix, int length) {
		return fixedString(inString, prefix, length, false);
	}

	public static String[] splitString(String inString, String del) {
		StringTokenizer st = new StringTokenizer(inString, del);
		String[] res = new String[st.countTokens() + 1];
		for (int i = 0; i <= st.countTokens(); i++)
			res[i] = st.nextToken();
		return res;
	}

	//------------------------------------------------
	private static String fixedString(String in, char pre, int len, boolean leftPos) {
		if (in == null)
			return "";
		if (in.getBytes().length >= len)
			return in.substring(0, len);

		StringBuffer sb = new StringBuffer(in);
		for (int i = in.getBytes().length; i < len; i++) {
			if (leftPos)
				sb.insert(0, pre); //0000001
			else
				sb.append(pre); //1000000
		}
		return sb.toString();
	}
	//----------
	public static Date stringToDate(String strDate) {
		Date d = null;
		if (strDate.length() == 8) {
			try {
				int yyyy = Integer.parseInt(strDate.substring(0, 4));
				int mm = Integer.parseInt(strDate.substring(4, 6));
				int dd = Integer.parseInt(strDate.substring(6, 8));
				Calendar cal = Calendar.getInstance();
				cal.set(yyyy, mm, dd);
				d = cal.getTime();
			} catch (NumberFormatException nfe) {
				Utilities.print("Invalid dateString:" + strDate);
			}
		}
		return d;
	}
	public static Calendar stringToCalendar(String strDate) {
		Calendar c = null;
		if (strDate.length() == 8) {
			try {
				int yyyy = Integer.parseInt(strDate.substring(0, 4));
				int mm = Integer.parseInt(strDate.substring(4, 6));
				if (mm > 0)
					mm--;
				int dd = Integer.parseInt(strDate.substring(6, 8));
				Calendar cal = Calendar.getInstance();
				cal.set(yyyy, mm, dd);
				c = cal;
				Utilities.print("stringToCalendar: " + strDate + " ->" + c.getTime().toString());
			} catch (NumberFormatException nfe) {
				Utilities.print("Invalid dateString:" + strDate);
			}
		}
		return c;
	}

	/*  public static FixedDecimal stringToFixedDecimal(String real, String dec){
		if(real == null || real.equals("")) real = "000";
		if(dec == null || dec.equals("")) dec = "00";
		return new FixedDecimal(real+"."+dec,6,2);
	  }*/

}
