package com.sap.ip.me.mdk.api.awt.gui.panel.navigation;

import java.awt.Image;
import java.awt.event.MouseListener;

import com.sap.ip.me.mdk.api.awt.gui.component.ComponentConstants;
import com.sap.ip.me.mdk.api.awt.gui.panel.ImageNavPanel;
/**
 * Create the navigation bar to browse through a table. The buttons are page up and down, first page
 * and last page.
 */
public class PageNavPanel extends ImageNavPanel {

	private static Image enImgFirstRec = ComponentConstants.getImage(ComponentConstants.iconTopPage);
	private static Image enImgPrevRec = ComponentConstants.getImage(ComponentConstants.iconPrevPage);
	private static Image enImgNextRec = ComponentConstants.getImage(ComponentConstants.iconNextPage);
	private static Image enImgLastRec = ComponentConstants.getImage(ComponentConstants.iconLastPage);

	private static Image deImgFirstRec = ComponentConstants.getImage(ComponentConstants.iconTopPageOff);
	private static Image deImgPrevRec = ComponentConstants.getImage(ComponentConstants.iconPrevPageOff);
	private static Image deImgNextRec = ComponentConstants.getImage(ComponentConstants.iconNextPageOff);
	private static Image deImgLastRec = ComponentConstants.getImage(ComponentConstants.iconLastPageOff);

	private static Image[] enableImages = { enImgFirstRec, enImgPrevRec, enImgNextRec, enImgLastRec };
	private static Image[] disableImages = { deImgFirstRec, deImgPrevRec, deImgNextRec, deImgLastRec };

	public PageNavPanel() {
		this(null, null, null);
	}
	public PageNavPanel(MouseListener commonListener) {
		this(commonListener, null, null);
	}
	public PageNavPanel(MouseListener commonListener, String[] targetPages, String[] targetHandlers) {
		super(enableImages, disableImages, commonListener, targetPages, targetHandlers);
	}
}
