package com.sap.ip.me.mdk.api.awt.gui.page;

import java.awt.Component;
import java.awt.event.MouseListener;

import com.sap.ip.me.mdk.api.awt.gui.component.LinkButton;
import com.sap.ip.me.mdk.api.awt.gui.component.ListPanel;
import com.sap.ip.me.mdk.api.awt.gui.component.TextLabel;
import com.sap.ip.me.mdk.api.awt.gui.panel.navigation.PageNavPanel;
import com.sap.ip.me.mdk.api.awt.gui.panel.navigation.TopNavLink;

/**
 * Creates a list with plain textstring - no detail links.
 */
public abstract class NoDetailListPage extends BasicPage {

	private LinkButton homeLink = null;
	protected LinkButton createLink = null;
	protected LinkButton backLink = null;
	private ListPanel listTable = null;
	private TopNavLink topLink = null;
	private PageNavPanel pageNav = null;
	protected MouseListener actionHandler = null;

	private NoDetailListPage() {
	}
	public NoDetailListPage(MouseListener actionHandler) {
		super();
		this.actionHandler = actionHandler;

		listTable = new ListPanel();
		this.setBody(listTable);

		pageNav = new PageNavPanel();
		pageNav.setCommonActionHandler(actionHandler);
		this.setFooterNavBar(pageNav);

	}
	public void setCreateActionAttributes(String targetPage, String targetHandler) {
		createLink.setTargetPage(targetPage);
		createLink.setTargetHandler(targetHandler);
	}
	public void setPageNavHandlers(String[] handlerNames) {
		pageNav.setTargetHandler(handlerNames);
	}
	public void setTopLinkCommand(String targetPage, String handlerName) {
		homeLink.setTargetPage(targetPage);
		homeLink.setTargetHandler(handlerName);
	}
	public void setFooterMessage(String msgText) {
		pageNav.setMessageText(msgText);
	}
	public void setPagingContols(Component[] c) {
		pageNav.addToLeft(c);
	}
	public void removePageNav() {
		this.remove(pageNav);
		validate();
	}

	public void setList(TextLabel[] label, TextLabel[] fields) {
		listTable.removeAll();
		int count = label.length < fields.length ? label.length : fields.length;
		for (int i = 0; i < count; i++)
			listTable.appendLine(label[i], fields[i]);
		listTable.validate();
	}

	public void disableFirstPrevPageNav() {
		pageNav.disableFirstAndPrevious();
	}
	public void disableNextLastPageNav() {
		pageNav.disableNextAndLast();
	}
	public void enableFirstPrevPageNav() {
		pageNav.enableFirstAndPrevious();
	}
	public void enableNextLastPageNav() {
		pageNav.enableNextAndLast();
	}

	abstract public void initializePage();
	abstract public void destroyPage();
	abstract public void updatePage();
}
