package com.sap.ip.me.mdk.api.awt.gui.page;

import java.awt.Image;
import java.awt.event.MouseListener;

import persistenceexample4.Constants;

import com.sap.ip.me.mdk.api.awt.gui.component.ComponentConstants;
import com.sap.ip.me.mdk.api.awt.gui.component.LinkButton;
import com.sap.ip.me.mdk.api.awt.gui.component.ListHeaderPanel;
import com.sap.ip.me.mdk.api.awt.gui.component.ListPanel;
import com.sap.ip.me.mdk.api.awt.gui.component.TextLabel;
import com.sap.ip.me.mdk.api.awt.gui.panel.navigation.RecordNavPanel;
import com.sap.ip.me.mdk.api.awt.gui.panel.navigation.TopNavLink;

/**
 * Detail page. It displayes two columns. Th eleft column serves as link, which can be clicked
 * to get details about the entry
 */
public abstract class DetailPage extends BasicPage {

	public LinkButton homeLink = null;
	private	String[] detailTargets =  new String[] { "firstRecord", "prevRecord", "nextRecord", "lastRecord" };

	private LinkButton listLink = null;
	private LinkButton deleteLink = null;
	private ListPanel listTable = null;
	private ListHeaderPanel listHeaderTable = null;
	private RecordNavPanel recordNav = null;
	protected MouseListener actionHandler = null;
	protected static Image imgDel = ComponentConstants.getImage(ComponentConstants.iconDelete);
	//	protected static Image imgEdit = Utilities.getImage(Utilities.iconEdit);
	protected static Image imgList = ComponentConstants.getImage(ComponentConstants.iconCarList);
	protected static Image imgTop = ComponentConstants.getImage(ComponentConstants.iconBackToTop);

	private DetailPage() {
	}
	public DetailPage(MouseListener actionHandler) {
		super();
		this.actionHandler = actionHandler;

		homeLink = new LinkButton(Constants.TXT_HOME);
		homeLink.setTargetPage(Constants.TP_CARHOME);
		homeLink.setTargetHandler(Constants.HND_SHOWHOME);
		homeLink.addMouseListener(this.actionHandler);
		TopNavLink topLink = new TopNavLink();
		topLink.setLinks(new LinkButton[] { homeLink });
		topLink.addMouseListener(actionHandler);
		this.setTopLink(topLink);
		this.setTopLinkCommand(Constants.TP_CARHOME, Constants.HND_SHOWHOME);

		deleteLink = new LinkButton(imgDel);
		deleteLink.addMouseListener(actionHandler);
		listLink = new LinkButton(imgList);
		listLink.addMouseListener(actionHandler);
		this.setActionBarLinks(new LinkButton[] { deleteLink });

		listTable = new ListPanel();
		this.setBody(listTable);
		listHeaderTable = new ListHeaderPanel();
		this.setBody(listHeaderTable);

		recordNav = new RecordNavPanel();
		recordNav.setCommonActionHandler(actionHandler);
		recordNav.setTargetHandler(detailTargets);
		this.setFooterNavBar(recordNav);

	}
	public void setListActionAttributes(String targetPage, String targetHandler) {
		listLink.setTargetPage(targetPage);
		listLink.setTargetHandler(targetHandler);
	}
	public void setDeleteActionAttributes(String targetPage, String targetHandler) {
		deleteLink.setTargetPage(targetPage);
		deleteLink.setTargetHandler(targetHandler);
	}
	public void setDeleteActionButtonImage(Image icon) {
		deleteLink.setImage(icon);
	}

//	public void setRecordNavCodes(int[] comCode){
//			recordNav.setActionCode(comCode);
//	}

	public void setRecordNavHandlers(String[] handlerNames){
			recordNav.setTargetHandler(handlerNames);
	}
	public void setTopLinkCommand(String targetPage, String handlerName) {
		homeLink.setTargetPage(targetPage);
		homeLink.setTargetHandler(handlerName);
	}
	
	public void setFooterMessage(String msgText){
		recordNav.setMessageText(msgText);
	}

	public void setList(TextLabel[] label, TextLabel[] fields) {
		listTable.removeAll();
		int count = label.length < fields.length ? label.length : fields.length;
		for (int i = 0; i < count; i++)
			listTable.appendLine(label[i], fields[i]);
		listTable.validate();
	}

	abstract public void initializePage();
	abstract public void destroyPage();
	abstract public void updatePage();
}
