package com.sap.ip.me.mdk.api.awt.gui.page;

import java.awt.Panel;
import java.util.Hashtable;

/**
 * Represents the basic interface for a ME page. 
 * From this interface we implement:
 *  - ControllerPage that is the basis for all "center" panels with event handling.
 *  - BasicPage that is the basis for all list oriented pages.
 */

public abstract class AbstractMEPage extends Panel {
	public static final String ATTR_RESULTMSG = "RESULTMSG";
	public static final String ATTR_NAVHELPER = "NAVHELPER";
	public static final String ATTR_HANDLERARG = "HANDLERARG";
	public static final String ATTR_CHARS_NAV = "CHARNAV";
	public static final String ATTR_CUR_NAV_CHAR = "CURNAVCHAR";
	public static Hashtable attributeTable = null;

	public AbstractMEPage() {
		super();
		if (AbstractMEPage.attributeTable == null)
			AbstractMEPage.attributeTable = new Hashtable();
	}
	abstract public void initializePage();

	abstract public void destroyPage();

	public void updatePage() {
		this.repaint();
	}

	public void setAttribute(Object key, Object value) {
		AbstractMEPage.attributeTable.put(key, value);
	}

	public Object getAttribute(Object key) {
		return AbstractMEPage.attributeTable.get(key);
	}
	public void clearAttributes() {
		AbstractMEPage.attributeTable.clear();
	}
	public void removeAttribute(Object key) {
		AbstractMEPage.attributeTable.remove(key);
	}
	public Object getObject() {
		return null;
	}
}
