package com.sap.ip.me.mdk.api.awt.gui.component;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

//import com.sap.ip.me.mdk.api.awt.gui.util.Utilities;

/**
 * Generates text
 */
public class TextLabel extends Component {

	private String label = null;
	private Color textColor = ComponentConstants.labelTextColor;
	private Font textFont = ComponentConstants.fntPlain10Dialog;

	public TextLabel() {
		this(null);
	}
	public TextLabel(String str) {
		label = str;
	}
	public TextLabel(String str, Font fnt, Color clr) {
		label = str;
		textFont = fnt;
		textColor = clr;
	}
	public void addNotify() {
		super.addNotify();
		java.awt.Dimension d = getSize();
		if (d.width == 0 || d.height == 0) {
			setSize(this.figureMySize(this.getGraphics()));
		}
	}

	public void update(java.awt.Graphics g) {
		paint(g);
	}
	public void setFont(Font f) {
		textFont = f;
		repaint();
	}
	public void setTextColor(Color c) {
		textColor = c;
	}
	public synchronized void setLabel(String lab) {
		label = lab;
		invalidate();
		this.repaint();
	}
	public java.awt.Dimension getMinimumSize() {
		return getPreferredSize();
	}

	public java.awt.Dimension getPreferredSize() {
		return figureMySize(getGraphics());
	}

	protected Dimension figureMySize(Graphics g) {
		int width = 20;
		int height = 20;
		if (g != null) {
			FontMetrics fm = g.getFontMetrics();
			if (label != null) {
				height = fm.getHeight(); //+6;
				width = ComponentConstants.pixelsWideForString(label, fm);
				width += 2;
			}
		}
		return new Dimension(width, height);
	}

	public void paint(Graphics g) {
		if (isShowing()) {

			if (label != null && label.length() > 0) {
				g.setColor(textColor == null ? getForeground() : textColor);
				g.setFont(textFont);
				int y = (getSize().height + g.getFontMetrics().getHeight()) / 2 - g.getFontMetrics().getAscent() / 2 + 1;
				g.drawString(label, 3, y);

			}
		}
	}
}
