package com.sap.ip.me.mdk.api.awt.gui.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Panel;

import com.sap.ip.me.mdk.api.awt.gui.layout.ParagraphLayout;

/**
 * Generates a list panel for the center page
 */
public class ListHeaderPanel extends Panel {

	private boolean bDrawBorder = true;
	private boolean bDrawBackGround = true;
	protected Color bgColor = ComponentConstants.tableHeaderBGColor;
	private String lineMask = "B"; //bottom

	public ListHeaderPanel() {
		this(null, null);
	}
	public ListHeaderPanel(Component[] left, Component[] right) {
		super(new ParagraphLayout(2, 2, 2, 0, 0, 0));
		setList(left, right);
	}
	public void appendLine(Component l) {
		this.appendLine(new TextLabel(""), l);
	}
	public void appendLine(Component l, Component r[]) {
		add(l, ParagraphLayout.NEW_PARAGRAPH);
		if (r != null) {
			for (int i = 0; i < r.length; i++)
				add(r[i]);
		}
		invalidate();
		repaint();
	}
	public void appendLine(Component l, Component r) {
		add(l, ParagraphLayout.NEW_PARAGRAPH);
		if (r != null)
			add(r);
		validate();
	}
	public void setList(Component[] l, Component[] r) {
		if (l == null || r == null)
			return;
		int len = (l.length < r.length) ? l.length : r.length;
		for (int i = 0; i < len; i++)
			this.appendLine(l[i], r[i]);
	}

	public void enableBackground(boolean state) {
		bDrawBackGround = state;
	}
	public void enableBorder(boolean state) {
		bDrawBorder = state;
	}
	public void setBorderMask(String mask) {
		lineMask = mask;
		repaint();
	}
	public void paint(Graphics g) {

		if (bDrawBackGround) {
			g.setColor(bgColor);
			g.fillRect(1, 1, getSize().width, getSize().height);
		}
		if (bDrawBorder) {
			g.setColor(Color.gray);
			if (lineMask.indexOf("T") > -1)
				drawTopLine(g);
			if (lineMask.indexOf("B") > -1)
				drawBottomLine(g);
			if (lineMask.indexOf("R") > -1)
				drawRightLine(g);
			if (lineMask.indexOf("L") > -1)
				drawLeftLine(g);
		}
		super.paint(g);
	}
	private void drawTopLine(Graphics g) {
		g.drawLine(0, 0, getSize().width, 0);
	}
	private void drawBottomLine(Graphics g) {
		g.drawLine(0, getSize().height - 1, getSize().width, getSize().height - 1);
	}
	private void drawLeftLine(Graphics g) {
		g.drawLine(0, 0, 0, getSize().height - 1);
	}
	private void drawRightLine(Graphics g) {
		g.drawLine(getSize().width - 1, 0, getSize().width - 1, getSize().height);
	}

	public Color getBgColor() {
		return bgColor;
	}

	public void setBgColor(Color color) {
		bgColor = color;
	}

}
