package com.sap.ip.me.mdk.api.awt.gui.component;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;

/**
 * Implements a link - a text that is underlined and generates an event - (like a HTML hyperlink)
 */
public class LinkButton extends Component {
	private String label;
	private String targetPage;
	private String targetHandler;
	private boolean mouseIsIn = false;
	private boolean mouseIsDown = false;
	private static Cursor handCur = new Cursor(Cursor.HAND_CURSOR);
	private static Cursor arrowCur = new Cursor(Cursor.DEFAULT_CURSOR);
	private static Cursor hourCur = new Cursor(Cursor.WAIT_CURSOR);
	private static Cursor defCur = arrowCur;
	transient ActionListener actionListener;

	private Color textColor = ComponentConstants.linkTextColor;
	private Image image = null;
	private Image image1 = null;
	private Image image2 = null;
	private Font textFont = ComponentConstants.fntBold10Dialog;

	public LinkButton(String label, Image image, Image image2) {
		super();
		this.label = label;
		this.image1 = image;
		this.image2 = image2;
		this.image = this.image1; //default
		enableEvents(java.awt.AWTEvent.MOUSE_EVENT_MASK);
	}
	public LinkButton(String lab, Image eImage) {
		this(lab, eImage, null);
	}
	public LinkButton(Image eImage, Image dImage) {
		this(null, eImage, dImage);
	}
	public LinkButton(String label) {
		this(label, null, null);
	}
	public LinkButton(Image image) {
		this(null, image, null);
	}

	public void showWaitCursor() {
		this.setCursor(hourCur);
	}
	public void showDefaultCursor() {
		this.setCursor(defCur);
		validate();
	}

	public void addNotify() {
		super.addNotify();
		java.awt.Dimension d = getSize();
		if (d.width == 0 || d.height == 0) {
			setSize(this.figureMySize(this.getGraphics()));
		}
	}

	protected Dimension figureMySize(Graphics g) {
		int width = 18;
		int height = 14;

		if (g != null) {
			FontMetrics fm = g.getFontMetrics();
			if (label != null) {
				height = fm.getHeight(); //+6;
				width = ComponentConstants.pixelsWideForString(label, fm) + 6;
			}
			if (this.image != null) {
				int imgWidth = image.getWidth(this);
				imgWidth += 4;
				if (label != null && label.length() > 0)
					width = width + imgWidth; // + 2;
				int imgHeight = image.getHeight(this);
				//imgHeight += 2;
				height = height > imgHeight ? height : imgHeight;
			}
		}
		return new Dimension(width, height);
	}

	public String getLabel() {
		return label;
	}

	public synchronized void setLabel(String newLabel) {
		invalidate();
		label = newLabel;
		validate();
		repaint();
	}
	public void setImage(Image img) {
		image = img;
		validate();
		repaint();

	}
	public void setEnabled(boolean state) {
		if (image2 != null) {
			if (state)
				this.setImage(image1);
			else
				this.setImage(image2);
		}
		super.setEnabled(state);
	}

	public void setTargetPage(String command) {
		targetPage = command;
	}
	public String getTargetPage() {
		return (targetPage == null ? label : targetPage);
	}

	public void setTargetHandler(String handler) {
		this.targetHandler = handler;
	}
	public String getTargetHandler() {
		return this.targetHandler;
	}

	//	2 Methods for grouping the outpunt by starting character
	/**
	 * Method setTargetPage.- set targetPage difference between special character group
	 * and all. 
	 */
	public void setTargetPage(String commandAll, String commandChar, String charNav) {
		if (charNav.equals("All")) {
			targetPage = commandAll;
		} else
			targetPage = commandChar;
	}
	/**
	 * Method setTargetHandler.- set handler difference between special character group
	 * and all. 
	 */
	public void setTargetHandler(String handlerAll, String handlerChar, String charNav) {
		if (charNav.equals("All")) {
			this.targetHandler = handlerAll;
		} else
			this.targetHandler = handlerChar;
	}
	public synchronized void addActionListener(ActionListener l) {
		actionListener = AWTEventMulticaster.add(actionListener, l);
		//	System.out.println("actionListener added!");
	}
	public synchronized void removeActionListener(ActionListener l) {
		actionListener = AWTEventMulticaster.remove(actionListener, l);
	}

	protected void processEvent(AWTEvent e) {
		if (e instanceof ActionEvent) {
			processActionEvent((ActionEvent) e);
			return;
		}
		super.processEvent(e);
	}

	protected void processActionEvent(ActionEvent e) {
		if (actionListener != null) {
			actionListener.actionPerformed(e);
		}
	}

	public void paint(Graphics g) {
		if (isShowing()) {
			if (!isEnabled()) {
				mouseIsIn = false;
				mouseIsDown = false;
			}

			int imgPosX = 0;
			int imgPosY = 0;
			int txtPosX = 0;
			int txtPosY = 0;
			int elWidth = 0;
			int elHeight = 0;

			FontMetrics fm = g.getFontMetrics();

			if (image != null && (label == null || label.length() == 0)) {
				elWidth = image.getWidth(this);
				elHeight = image.getHeight(this);
				imgPosX = (getSize().width - elWidth) / 2;
				imgPosY = (getSize().height - elHeight) / 2;
			} else if (image != null && label != null && label.length() > 0) {
				elWidth = image.getWidth(this) + fm.stringWidth(label) - 4;
				elHeight = image.getHeight(this);
				imgPosX = (getSize().width - elWidth) / 2; //to center 
				imgPosY = (getSize().height - elHeight) / 2;
				txtPosX = imgPosX + image.getWidth(this) + 2;
				txtPosY = (getSize().height + 2 + fm.getHeight()) / 2 - (fm.getAscent() / 2); //(getSize().height + fm.getSize().height- fm.getDescent())/2;
			} else if (image == null && label != null && label.length() > 0) {
				elWidth = fm.stringWidth(label);
				elHeight = fm.getHeight();
				txtPosX = ((getSize().width - elWidth) / 2) + fm.getLeading() + 2;
				txtPosY = (getSize().height + fm.getHeight()) / 2 - fm.getAscent() / 2;
			}

			if (image != null)
				g.drawImage(image, imgPosX, imgPosY, this);

			if (label != null && label.length() > 0) {
				if (isEnabled())
					g.setColor(textColor == null ? getForeground() : textColor);
				else
					g.setColor(Color.gray);

				g.setFont(textFont);
				g.drawString(label, txtPosX, txtPosY);
			}
		}
	}
	public Dimension getMinimumSize() {
		return getPreferredSize();
	}

	public java.awt.Dimension getPreferredSize() {
		return figureMySize(getGraphics());
	}

	public void processMouseEvent(MouseEvent evt) {

		if (isEnabled()) {
			switch (evt.getID()) {
				case MouseEvent.MOUSE_ENTERED :
					defCur = handCur;
					mouseIsIn = true;
					repaint();
					break;
				case MouseEvent.MOUSE_EXITED :
					defCur = arrowCur;
					mouseIsIn = false;
					repaint();
					break;
				case MouseEvent.MOUSE_PRESSED :
					defCur = handCur;
					mouseIsDown = true;
					repaint();
					break;
				case MouseEvent.MOUSE_RELEASED :
					defCur = handCur;
					mouseIsDown = false;
					repaint();
					break;
			}
			setCursor(defCur);
			super.processMouseEvent(evt);
		}

	}

	public Color getTextColor() {
		return textColor;
	}

	public void setTextColor(Color color) {
		textColor = color;
	}

}
