package com.sap.ip.me.mdk.api.awt.gui.component;

import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

/**
 * Implements an input field
 */
public class InputField extends TextField implements TextListener{
	
	public boolean bNUMBER = false;
	public boolean btnsEnabled = false;

	private LinkButton[] linkButtons = null;
	private int MAXCHARCOUNT = 255;
	private String goodText = null;
	
	public InputField(int width, int maxCount) {
		super(width);
		if(maxCount > 0) MAXCHARCOUNT = maxCount;
		this.addTextListener(this);
	}
	public void setAsNumberField(){
		bNUMBER = true;
	}
	public void setMandatory(LinkButton[] buttons){
		if(buttons == null) return;
		linkButtons = buttons;
	}
	private void disableButtons(){
		if(linkButtons == null || btnsEnabled == false) return;
		for(int i=0; i<linkButtons.length; i++)
			linkButtons[i].setEnabled(false);
		btnsEnabled = false;
	}
	private void enableButtons(){
		if(linkButtons == null || btnsEnabled) return;
		for(int i=0; i<linkButtons.length; i++)
			linkButtons[i].setEnabled(true);
		btnsEnabled = true;
	}
  public void textValueChanged(TextEvent textevent){
  	String s = getText();
  	int cPos = getCaretPosition();
    if(s == null || s.length() == 0){
    	goodText = "";
    	disableButtons();
       return;
    }
    
   //max limit
   if (s.length() > MAXCHARCOUNT){ 
   	setText(goodText);
   	if(cPos > 0) setCaretPosition(cPos-1);  
	ComponentConstants.beep();
   }
   
   //number field 
   if(bNUMBER && !isInteger(s)){
      setText(goodText);
      if(cPos > 0) setCaretPosition(cPos-1); 
      ComponentConstants.beep();
    }
    
    //mandatory check
    if(linkButtons!=null){ 
  		if(getText().length() > 0 ) enableButtons();
  		else disableButtons();
    }
    goodText = getText();
	}
	
	private boolean isInteger(String s){
		try{
    	int	i = Integer.parseInt(s);
		}catch(NumberFormatException x) {
      return false;
    }
    return true;
	}
	
	public int getIntegerValue(){
		if(!bNUMBER) return getText().hashCode();
		String s = getText();
		if(s == null || s.length() == 0) return 0;
   	return Integer.parseInt(s);
	}
}
