package com.sap.ip.me.mdk.api.awt.gui.component;

import java.awt.Choice;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Hashtable;

/**
 * Implementation of comboBox that also provides IDs for event handling
 */
public class ComboBox extends Choice implements ItemListener {
	private Hashtable dataTable = null;
	private LinkButton[] linkButtons = null;
	public static final String BLANK = "             ";

	public ComboBox() {
		super();
		this.addItemListener(this);
		dataTable = new Hashtable(1);
	}
	public void addItem(String item, Object data) {
		super.addItem(item);
		dataTable.put(item, data);
	}
	public void remove(String item) {
		super.remove(item);
		dataTable.remove(item);
	}
	public void remove(int nItem) {
		dataTable.remove(this.getItem(nItem));
		remove(nItem);
	}
	public void removeAll() {
		super.removeAll();
		dataTable.clear();
	}
	public String getItemKey(Object data) {
		if (!dataTable.contains(data))
			return "";
		for (Enumeration e = dataTable.keys(); e.hasMoreElements();) {
			String key = (String) e.nextElement();
			if (data.equals(dataTable.get(key)))
				return key;
		}
		return "";
	}
	public Object getItemData(String item) {
		if (dataTable == null)
			return null;
		return dataTable.get(item);
	}
	public Object getItemData(int nItem) {
		if (dataTable == null)
			return null;
		return dataTable.get(this.getItem(nItem));
	}
	public Object getSelectedItemData() {
		return getItemData(this.getSelectedItem());
	}
	public void setMandatory(LinkButton[] links) {
		linkButtons = links;
	}
	private void disableButtons() {
		if (linkButtons == null)
			return;
		for (int i = 0; i < linkButtons.length; i++)
			linkButtons[i].setEnabled(false);
	}
	private void enableButtons() {
		if (linkButtons == null)
			return;
		for (int i = 0; i < linkButtons.length; i++)
			linkButtons[i].setEnabled(true);
	}
	public void itemStateChanged(ItemEvent event) {
		if (getSelectedItem().equals("") || getSelectedItem().equals(BLANK)) {
			disableButtons();
            ComponentConstants.beep();
		} else {
			enableButtons();
		}
	}
}
