package com.sap.ip.me.mdk.api.awt.gui.component;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Label;
/**
 * Generates a label with a specific background. It is used by MenuPanel.
 */

public class BorderedLabel extends Label {
	private Font fnTextFont = null;
	private Color clBorderColor = null;
	private boolean bDrawBorder = true;

	public BorderedLabel(String text) {
		super(text);
	}

	public BorderedLabel(String text, Color borderColor) {
		super(text);
		clBorderColor = borderColor;
	}

	public BorderedLabel(String text, int a) {
		super(text);
		setAlignment(a);
	}
	public void setBorderColor(Color c) {
		clBorderColor = c;
	}
	public void enableBorder(boolean state) {
		bDrawBorder = state;
	}
	public void update(Graphics g) {
		paint(g);
	}
	public void paint(Graphics g) {
		super.paint(g);
		if (bDrawBorder) {
			g.setColor(clBorderColor != null ? clBorderColor : Color.gray);
			g.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
		}
	}
}
