package genericsyncexample1;

/**
 * @author Sigi
 *
 * Helper classes useful for developers using the ME. This package is for encoding characters and strings
 * for JSP so that strings are representing properly in HTML
 */


public class Encoding {
/**
 * Encode characters to be shown in a web browser.
 * @param c the character to be encoded
 * @return  The encoded parameter as string
 */

  public static String encodeForHtml(char c) {
        switch (c) {
            case '\t':
                return "    ";

            case '<':
                return "&lt;";
            case '>':
                return ("&gt;");
            case '&':
                return ("&amp;");
            case '"':
                return ("&quot;");
            case '\u00e0':
                return ("&agrave;");
            case '\u00c0':
                return ("&Agrave;");
            case '\u00e2':
                return ("&acirc;");
            case '\u00e4':
                return ("&auml;");
            case '\u00c4':
                return ("&auml;");
            case '\u00c2':
                return ("&Acirc;");
            case '\u00e5':
                return ("&aring;");
            case '\u00c5':
                return ("&Aring;");
            case '\u00e6':
                return ("&aelig;");
            case '\u00c6':
                return ("&AElig;");
            case '\u00e7':
                return ("&ccedil;");
            case '\u00c7':
                return ("&Ccedil;");
            case '\u00e9':
                return ("&eacute;");
            case '\u00c9':
                return ("&Eacute;");
            case '\u00e8':
                return ("&egrave;");
            case '\u00c8':
                return ("&Egrave;");
            case '\u00ea':
                return ("&ecirc;");
            case '\u00ca':
                return ("&Ecirc;");
            case '\u00eb':
                return ("&euml;");
            case '\u00cb':
                return ("&Euml;");
            case '\u00ef':
                return ("&iuml;");
            case '\u00cf':
                return ("&Iuml;");
            case '\u00f4':
                return ("&ocirc;");
            case '\u00d4':
                return ("&Ocirc;");
            case '\u00f6':
                return ("&ouml;");
            case '\u00d6':
                return ("&Ouml;");
            case '\u00f8':
                return ("&oslash;");
            case '\u00d8':
                return ("&Oslash;");
            case '\u00df':
                return ("&szlig;");
            case '\u00f9':
                return ("&ugrave;");
            case '\u00d9':
                return ("&Ugrave;");
            case '\u00fb':
                return ("&ucirc;");
            case '\u00db':
                return ("&Ucirc;");
            case '\u00fc':
                return ("&uuml;");
            case '\u00dc':
                return ("&Uuml;");
            case '\u00ae':
                return ("&reg;");
            case '\u00a9':
                return "&copy;";
            case '\u00ac':
                return "&euro;";
            default:
                return ("" + c);
        }
  }

    /**
     * Encode a whole string into characters to be shown in a web browser.
     * @param ascii the character to be encoded
     * @return  The encoded parameter as string
     */

    public static String encodeForHtml(String ascii) {
        StringBuffer sb = new StringBuffer();
        int length = ascii.length();
        for (int n = 0; n < length; n++) {
            char c = ascii.charAt(n);
            sb.append(encodeForHtml(c));
        }
        return sb.toString();
    }
}