package example3;
import java.io.IOException;
import java.util.Vector;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.sap.ip.me.api.logging.AbstractLogging;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Severities;
import com.sap.ip.me.api.runtime.jsp.AbstractMEHttpServlet;
import com.sap.ip.me.api.services.MEResourceBundle;

import example3.bean.TableViewBean;
import example3.dataHandler.BasicDataHandler;

// Display information about your ME client installation

public class SystemInfo extends AbstractMEHttpServlet implements Constants {
	public static MEResourceBundle RESOURCE_BUNDLE;
	private TableViewBean dataBean;
	private String headLine;

	/**
	 * Must be overwritten - return the name of the application
	 */
	public String getApplicationName() {
		return MI_APPLICATION_NAME;
	}

	/**
	 * doIntialize - called when the servlet is activated the first time
	 */
	public void doInitialize() throws ServletException {
		setResourceBundle("example3.properties.configExampleResBundle");
		RESOURCE_BUNDLE = getResourceBundle();
		// Prepare a log output - Level DEBUG - Information about classloader
		ClassLoader cl = getClass().getClassLoader();
		AbstractLogging aLogger = AppLog.getInstance(MI_APPLICATION_NAME);
		aLogger.log(Severities.DEBUG, Messages.getString("res_LOG_MESSAGE"), (cl == null ? "(null)" : cl.toString())); //$NON-NLS-1$ //$NON-NLS-2$
	}

	/**
	 * doHandleEvent - called any subsequent time when an event on the web client occurs.
	 */

	public String doHandleEvent(String eventName, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// Set the name of the JSP that has to be called when this method is finished.
		// INITIAL_JSP ist defined in the interface Constants.java and refers to welcome.jsp. This JSP displays a welcome message
		// and asks for your name. Welcome.jsp has a submit button which generates the event EVENT_NAME. When this event occurs,
		// the tableView.jsp is called and displays system information.
		// The welcome.jsp is called by default - if the servlet is called the first time or an unknown event occurs.

		// Set default JSP.
		String nextJSP = INITIAL_JSP;

		// Set default text for headline
		headLine = WELCOME_MESSAGE;

		if (eventName.equals(EVENT_NAME)) {
			// Event occurs when the submit button has been pressed.
			// We take the content of the inputfield in the JSP named NAME_OF_USER and store it in the bean.
			// This string is displayed as head line together with the WELCOME_MESSAGE_TRAILER and the WELCOME_MESSAGE_END
			// when the TABLEVIEW_JSP is displayed.
			headLine = WELCOME_MESSAGE_TRAILER + (String) request.getParameter("NAME_OF_USER") + WELCOME_MESSAGE_END; //$NON-NLS-1$
			nextJSP = TABLEVIEW_JSP;
		}

		// Get bean, if there is one, in the session context, otherwise create a new instance.
		getBeansFromContext(request);

		// Load bean with values.
		loadBean(request);

		// Put bean in the session context.
		putBeansIntoContext(request);

		// Exit with name of JSP.
		return nextJSP;
	}

	private void getBeansFromContext(HttpServletRequest request) {
		// Get bean from session context. There is a bean, when this servlet has already been called once.
		////	    dataBean = (TableViewBean) request.getSession().getAttribute(CONTEXT_BEAN);

		// No bean in session context - create a new instance.
		////		if (dataBean == null) dataBean = new TableViewBean();
		dataBean = new TableViewBean();
	}

	public void loadBean(HttpServletRequest request) {
		dataBean.setString(headLine);
		BasicDataHandler bdh = BasicDataHandler.instance();
		bdh.setMiHomeFolder(getMIHome());
		
		Vector data = bdh.getDataArray();
		dataBean.setTableContent(data);
		dataBean.setTableRows(bdh.getDataCount());
		dataBean.setTableColumns(bdh.getColumns());

	}

	public String stringLoad(String var) {
		// This method checks if a String is null - if so, it uses a standard text
		String vartmp = var;
		if (vartmp == null)
			vartmp = Messages.getString("res_NOT_SPECIFIED"); //$NON-NLS-1$

		return vartmp;
	}

	private void putBeansIntoContext(HttpServletRequest request) {
		// Put bean in session context
		if (dataBean == null) {
			request.getSession().removeAttribute(CONTEXT_BEAN);
		} else {
			request.getSession().setAttribute(CONTEXT_BEAN, dataBean);
		}
		// Put resource bundle in session context
		request.getSession().setAttribute(RESBUNDLE_BEAN, RESOURCE_BUNDLE);

	}

}