package example1.page;

import java.awt.Component;
import java.awt.Image;
import java.awt.TextField;
import java.util.Iterator;
import java.util.Vector;

import com.sap.ip.me.mdk.api.awt.gui.component.LinkButton;
import com.sap.ip.me.mdk.api.awt.gui.component.TextLabel;
import com.sap.ip.me.mdk.api.awt.gui.page.ControllerPage;
import com.sap.ip.me.mdk.api.awt.gui.page.NoDetailListPage;
import com.sap.ip.me.mdk.api.awt.gui.util.NavHelper;
import com.sap.ip.me.mdk.api.awt.gui.util.Utilities;

import example1.Constants;
/**
 * Customzing part of the NoDetailListPage
 */
public class NoDetailList extends NoDetailListPage {

	private static final String footerMsg = "Page";
	private static final String headerTitle = "MI Data:";

	private Vector data = null;
	private NavHelper navHelper = null;
	private TextLabel[] fieldNames = null;
	private TextLabel[] fieldValues = null;
	private TextField tfCurrentPage = null;
	private TextLabel tlPageString = null;
	private TextLabel tlTotalPage = null;
	private LinkButton gotoPage = null;
	private Image imgPlay = Utilities.getImage(Utilities.iconPlay);

	public NoDetailList(ControllerPage mainPage) {
		super(mainPage.getActionHandler());
		tfCurrentPage = Utilities.createTextField(1, 3, true);
		tfCurrentPage.setSize(tfCurrentPage.getSize().width / 2, tfCurrentPage.getSize().height * 2 / 3);
		tlPageString = new TextLabel(footerMsg);
		tlTotalPage = new TextLabel("/??");
		gotoPage = Utilities.createImageButton(imgPlay, "", Constants.HND_GETPAGE);
		gotoPage.addMouseListener(actionHandler);
	}

	public void initializePage() {
		String[] pgHandlers = { Constants.HND_FIRSTPAGE, Constants.HND_PREVPAGE, Constants.HND_NEXTPAGE, Constants.HND_LASTPAGE };
		this.setHeaderTexts(new String[] { headerTitle });
		this.setPageNavHandlers(pgHandlers);
		//		this.setCreateActionAttributes(ConstantsGUI.TP_CONCREATE, ConstantsGUI.HND_SHOWLISTCREATE);
		this.setPagingContols(new Component[] { tlPageString, tfCurrentPage, tlTotalPage, gotoPage });
	}
	public Object getObject() {
		if (Utilities.isNumber(tfCurrentPage.getText())) {
			int n = Integer.parseInt(tfCurrentPage.getText());
			if (n < 1)
				NavHelper.PG_CURPAGE = 1;
			else if (n > NavHelper.PG_PAGECOUNT)
				NavHelper.PG_CURPAGE = NavHelper.PG_PAGECOUNT;
			else
				NavHelper.PG_CURPAGE = n;
		}
		return navHelper;
	}
	public void destroyPage() {
		this.clearAttributes();
	}
	public void updatePage() {
		navHelper = (NavHelper) getAttribute(ATTR_NAVHELPER);
		data = (Vector) getAttribute(ATTR_OBJECTLIST);

		this.setHeaderTexts(new String[] { headerTitle });
		tfCurrentPage.setText("" + NavHelper.PG_CURPAGE);
		tlTotalPage.setLabel("/" + NavHelper.PG_PAGECOUNT);

		if (NavHelper.PG_TOPPREV)
			this.enableFirstPrevPageNav();
		else
			this.disableFirstPrevPageNav();
		if (NavHelper.PG_NEXTLAST)
			this.enableNextLastPageNav();
		else
			this.disableNextLastPageNav();

		Iterator dataIterator = data.iterator();
		fieldNames = new TextLabel[data.size()];
		fieldValues = new TextLabel[data.size()];
		int i = 0;
		Vector dataEntry = null;
		while (dataIterator.hasNext()) {
			dataEntry = (Vector) dataIterator.next();
			fieldNames[i] = new TextLabel(dataEntry.elementAt(0).toString());
			fieldValues[i] = new TextLabel(dataEntry.elementAt(1).toString());
			i++;
		}
		this.setList(fieldNames, fieldValues);
		validate();
	}

}
