package example1.page;

import java.awt.CardLayout;
import java.awt.Panel;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Vector;

import com.sap.ip.me.mdk.api.awt.gui.actionHandler.ActionHandler;
import com.sap.ip.me.mdk.api.awt.gui.layout.TableLayout;
import com.sap.ip.me.mdk.api.awt.gui.page.AbstractMEPage;
import com.sap.ip.me.mdk.api.awt.gui.page.BasicPage;
import com.sap.ip.me.mdk.api.awt.gui.page.ControllerPage;
import com.sap.ip.me.mdk.api.awt.gui.util.NavHelper;
import com.sap.ip.me.mdk.api.awt.gui.util.Utilities;

import example1.Constants;
import example1.actionHandler.PageActionHandler;
import example1.dataHandler.BasicDataHandler;
/**
 * CenterPage is a customized implementation for the panel that is displayed in the middle of the MI AWT screen. 
 * The initializePage() method loads the view that is an implementation of BasicPage. 
 * The customizing also includes the eventhandlig methods for navigation, like moving up and down in a list 
 */
public class CenterPage extends ControllerPage implements Constants {

	private static final int SPACER = 1;
	private static final String ATTR_HANDLERARG = "HANDLERARG";
	private BasicDataHandler dataHandler = null;
	private ActionHandler actionHandler = null;	
	private static String _syncType = null;

	private AbstractMEPage _currentPage = null;

	private NavHelper _navHelper = null;
	private CardLayout cardLayout = null;
	private Panel cardPanel = null;

	public CenterPage() {
		super();
		double size[][] = { { 2, TableLayout.FILL, 2 }, {
				SPACER, TableLayout.FILL }
		};
		setLayout(new TableLayout(size));

		cardLayout = new CardLayout();
		cardPanel = new Panel(cardLayout);
		add(cardPanel, "1,1");
		dataHandler = BasicDataHandler.instance();
		_navHelper = new NavHelper();
		actionHandler = new PageActionHandler(this);

		initializePage();
	}

	/*	public ActionHandler getActionHandler() {
			return actionHandler;
		}
		public ContactDataHandler getDataHandler(){
			return dataHandler;
		}
		public String getSyncType(){
			return _syncType;
		} */

	public void initializePage() {
		Utilities.setListCount(ROWS_PER_LONGPAGE);
		instantiatePage(TP_CONLONGLIST);
		activatePage(TP_CONLONGLIST);
		this.showList();
	}
	/**
	 * eventhandler methods
	 */

	public void gotoFirstPage() {
		Utilities.setTopPageIndex();
		showList();
	}
	public void gotoPrevPage() {
		Utilities.setPrevPageIndex();
		showList();
	}
	public void gotoNextPage() {
		Utilities.setNextPageIndex();
		showList();
	}
	public void gotoLastPage() {
		Utilities.set_recCount(BasicDataHandler.instance().getDataCount());
		Utilities.setLastPageIndex();
		showList();
	}

	public void getDesiredPage() {
		_navHelper = (NavHelper) _currentPage.getObject();
		Utilities.setDesiredPage(NavHelper.PG_CURPAGE);
		showList();
	}

	private void showList() {
		//get the objects from repository
		Utilities.set_recCount(BasicDataHandler.instance().getDataCount());
		Vector data = dataHandler.getDataArray(Utilities.getStartIndex(), Utilities.getListCount());

		NavHelper.PG_RECCOUNT = dataHandler.getDataCount();
		NavHelper.PG_CURPAGE = Utilities.getCurrentPageNumber();
		NavHelper.PG_PAGECOUNT = Utilities.getPageCount();
		NavHelper.PG_TOPPREV = Utilities.isTopPrevPagesAvailable();
		NavHelper.PG_NEXTLAST = Utilities.isNextLastPageAvailable();

		AbstractMEPage tPage = (AbstractMEPage) attributeTable.get(TP_CONLONGLIST);
		tPage.setAttribute(BasicPage.ATTR_OBJECTLIST, data);
		tPage.setAttribute(BasicPage.ATTR_NAVHELPER, _navHelper);
	}

	public void destroyPage() {
		removeAll();
	}
	public void instantiatePage(String nextPage) {
		if (nextPage == null || nextPage.equals(""))
			return;

		String pageClass = TP_PAGEBASE + nextPage;
		AbstractMEPage newPage = (AbstractMEPage) createObject(pageClass, this);

		if (newPage == null)
			return;

		attributeTable.put(nextPage, newPage);
		newPage.initializePage();
		cardPanel.add(nextPage, newPage);
		Utilities.print("ControllerPage:" + nextPage + " instance created and initialized!");
	}

	public void activatePage(String nextPage) {
		_currentPage = (AbstractMEPage) attributeTable.get(nextPage);
		cardLayout.show(cardPanel, nextPage);
		//_navHelper.RET_MESSAGE = "";
	}

	public boolean isPageInitialized(String pageName) {
		return attributeTable.containsKey(pageName);
	}

	public void updateCurrentPage() {
		_currentPage.updatePage();
	}

	public void deactivateCurrentPage() {
		_currentPage.destroyPage();
	}

	public void runHandler(String handlerName, Object arg) {
		NavHelper.RET_MESSAGE = "";
		if (handlerName == null || handlerName.equals(""))
			return;
		if (arg != null)
			setAttribute(ATTR_HANDLERARG, arg);
		try {
			Method methodInvoker = this.getClass().getMethod(handlerName, new Class[] {
			});
			methodInvoker.invoke(this, new Object[] {
			});
		} catch (Exception e) {
			e.printStackTrace();
			return;
		}
	}

	private static final Object createObject(String className, ControllerPage consParam) {
		Utilities.print("CenterPage.createObject called: " + consParam.getClass().toString());
		Object res = null;
		try {
			Class clazz = Class.forName(className);
			Class parType[] = { ControllerPage.class };
			Constructor con = clazz.getConstructor(parType);
			Object arglist[] = { consParam };
			res = con.newInstance(arglist);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return res;
	}

	/* (non-Javadoc)
	 * @see com.sap.ip.me.mdk.api.awt.gui.page.ControllerPage#getActionHandler()
	 */
	public ActionHandler getActionHandler() {
		return actionHandler;
	} 

	/* (non-Javadoc)
	 * @see com.sap.ip.me.mdk.api.awt.gui.page.ControllerPage#getSyncType()
	 */
	public String getSyncType() {
		return _syncType;
	}
}
