package example1.dataHandler;

import java.util.Iterator;
import java.util.Vector;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.conf.MEVersion;
import com.sap.ip.me.api.user.User;
import com.sap.ip.me.api.user.UserManager;

public class BasicDataHandler  {
	private static Vector retVector;
	private static BasicDataHandler bdh = null;

	private static String miHomeFolder;

	public static BasicDataHandler instance(){
		if(bdh == null) bdh = new BasicDataHandler();
		generateData();
		return bdh;
	}
	/**
	 * Method creates the demodata to be displayed
	 */
	private static void generateData() {
		Vector dataVec = new Vector();
		retVector = new Vector();

		// Load array in Bean with Information about the Mobile Engine, i is the index for the entries
		dataVec = new Vector();
		dataVec.addElement("Environment");
		dataVec.addElement("Value");
		retVector.addElement(dataVec);

		dataVec = new Vector();
		dataVec.addElement("Operating system");
		dataVec.addElement(stringLoad(Configuration.getOperatingSystemName()));
		retVector.addElement(dataVec);

		dataVec = new Vector();
		dataVec.addElement("VM vendor");
		dataVec.addElement(stringLoad(Configuration.getJVMVendorName()));
		retVector.addElement(dataVec);

		dataVec = new Vector();
		dataVec.addElement("MI runtime");
		dataVec.addElement(stringLoad(Configuration.getMERuntime()));
		retVector.addElement(dataVec);

		dataVec = new Vector();
		dataVec.addElement("MI folder");
		dataVec.addElement(stringLoad(Configuration.getInstallationDirectory()));
		retVector.addElement(dataVec);

		dataVec = new Vector();
		dataVec.addElement("MI main version");
		dataVec.addElement(stringLoad(MEVersion.getMainVersion()));
		retVector.addElement(dataVec);

		dataVec = new Vector();
		dataVec.addElement("MI build");
		dataVec.addElement(stringLoad(MEVersion.getBuild()));
		retVector.addElement(dataVec);

		dataVec = new Vector();
		dataVec.addElement("MI version info");
		dataVec.addElement(stringLoad(MEVersion.getFullName()));
		retVector.addElement(dataVec);

		dataVec = new Vector();
		dataVec.addElement("MI home URL");
		dataVec.addElement(stringLoad(stringLoad(getMiHomeFolder())));
		retVector.addElement(dataVec);

		// Check if user is logged in.

		dataVec = new Vector();
		dataVec.addElement("Current user");
		User actUser = UserManager.getInstance().getCurrentUser();
		if (actUser == null) {
			// Should never occur, since in ME 2.5 you always have to be logged in to start an application
			dataVec.addElement(stringLoad("Not logged in"));
		} else {
			dataVec.addElement(stringLoad(actUser.getUniqueID()));
		}
		retVector.addElement(dataVec);
	}

	private static String stringLoad(String var) {
		// This method checks if a String is null - if so, it uses a standard text
		String vartmp = var;
		if (vartmp == null)
			vartmp = "Not available";

		return vartmp;
	}

	public Vector getDataArray(int fromIndex, int count){
		Vector retSubVec = new Vector();
		Iterator dataIterator = retVector.iterator();
		int i = 0;
		Vector dataEntry = null;
		while (dataIterator.hasNext()) {
			dataEntry = (Vector) dataIterator.next();
			if (i >= fromIndex){
				retSubVec.add(dataEntry);
			}
			i++;
// Return when count has been reached			
			if (i >= (fromIndex+count)) return retSubVec;
		}	
// Return - there are less than required data in the Vector
		return retSubVec;
	}

	public Vector getDataArray(){
		return retVector;
	}

	public int getDataCount() {
		return retVector.size();
	}

	/**
	 * used to set the MI homefolder from the main application
	 */
	public void setMiHomeFolder(String string) {
		miHomeFolder = string;
	}

	public static String getMiHomeFolder() {
		return miHomeFolder;
	}
	
	

}
