package com.sap.ip.me.mdk.api.awt.gui.panel.navigation;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.event.MouseListener;

import com.sap.ip.me.mdk.api.awt.gui.component.BorderedPanel;
import com.sap.ip.me.mdk.api.awt.gui.component.LinkButton;

/**
 * Top level navigation
 */
public class TopNavLink extends Panel {
	private BorderedPanel rightPanel = null;
	private LinkButton topLinks[] = null;
	private MouseListener actionHandler = null;

	public TopNavLink() {
		super(new BorderLayout());
		rightPanel = new BorderedPanel(new FlowLayout(FlowLayout.RIGHT, 0, 0));
		rightPanel.enableBGDraw(false);
		rightPanel.enableBorderDraw(false);
		add(BorderLayout.EAST, rightPanel);
	}
	public void setCommonMouseListener(MouseListener msListener) {
		if (topLinks == null && topLinks.length == 0)
			return;
		for (int i = 0; i < topLinks.length; i++)
			topLinks[i].addMouseListener(msListener);
	}
	public void setLinks(LinkButton[] newLinks) {
		rightPanel.removeAll();
		topLinks = newLinks;
		for (int i = 0; i < topLinks.length; i++)
			rightPanel.add(topLinks[i]);
		validate();
	}
}
